/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.j2chartjs.data;

import de.yanwittmann.j2chartjs.dataset.BarChartDataset;
import de.yanwittmann.j2chartjs.dataset.BubbleChartDataset;
import de.yanwittmann.j2chartjs.dataset.ChartDataset;
import de.yanwittmann.j2chartjs.dataset.DoughnutPieChartDataset;
import de.yanwittmann.j2chartjs.dataset.LineChartDataset;
import de.yanwittmann.j2chartjs.dataset.PolarAreaChartDataset;
import de.yanwittmann.j2chartjs.dataset.RadarChartDataset;
import de.yanwittmann.j2chartjs.dataset.ScatterChartDataset;
import de.yanwittmann.j2chartjs.preset.ChartColors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MixedChartData {
    private List<String> labels = new ArrayList<String>();
    private List<ChartDataset> datasets = new ArrayList<ChartDataset>();

    public MixedChartData addDataset(ChartDataset ... dataset) {
        this.datasets.addAll(Arrays.asList(dataset));
        return this;
    }

    public MixedChartData removeDataset(ChartDataset dataset) {
        this.datasets.remove(dataset);
        return this;
    }

    public List<ChartDataset> getDatasets() {
        return this.datasets;
    }

    public MixedChartData setLabels(Collection<String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        }
        return this;
    }

    public MixedChartData addLabels(String ... label) {
        this.labels.addAll(Arrays.asList(label));
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public MixedChartData applyDefaultStylePerDatapoint() {
        this.datasets.forEach(ChartColors::applyDefaultStylePerDatapoint);
        return this;
    }

    public MixedChartData applyDefaultStylePerDataset() {
        this.datasets.forEach(ChartColors::applyDefaultStylePerDataset);
        return this;
    }

    public JSONObject toJson() {
        JSONObject chartData = new JSONObject();
        chartData.put("labels", this.getLabels());
        if (this.datasets != null) {
            JSONArray chartDatasets = new JSONArray();
            for (ChartDataset genericDataset : this.datasets) {
                JSONObject datasetJson = genericDataset.toJson();
                if (genericDataset instanceof BarChartDataset) {
                    datasetJson.put("type", (Object)"bar");
                } else if (genericDataset instanceof BubbleChartDataset) {
                    datasetJson.put("type", (Object)"bubble");
                } else if (genericDataset instanceof DoughnutPieChartDataset) {
                    datasetJson.put("type", (Object)"pie");
                } else if (genericDataset instanceof LineChartDataset) {
                    datasetJson.put("type", (Object)"line");
                } else if (genericDataset instanceof PolarAreaChartDataset) {
                    datasetJson.put("type", (Object)"polarArea");
                } else if (genericDataset instanceof RadarChartDataset) {
                    datasetJson.put("type", (Object)"radar");
                } else if (genericDataset instanceof ScatterChartDataset) {
                    datasetJson.put("type", (Object)"scatter");
                }
                chartDatasets.put((Object)datasetJson);
            }
            chartData.put("datasets", (Object)chartDatasets);
        }
        return chartData;
    }
}

