/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.j2chartjs.data;

import de.yanwittmann.j2chartjs.dataset.ChartDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class ChartData<T, DT, D> {
    protected List<String> labels = new ArrayList<String>();
    protected List<ChartDataset<DT, D>> datasets = new ArrayList<ChartDataset<DT, D>>();

    public T addDataset(ChartDataset<DT, D> ... datasets) {
        this.datasets.addAll(Arrays.asList(datasets));
        return (T)this;
    }

    public T removeDataset(ChartDataset<DT, D> dataset) {
        this.datasets.remove(dataset);
        return (T)this;
    }

    public List<ChartDataset<DT, D>> getDatasets() {
        return this.datasets;
    }

    public T setLabels(Collection<String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        }
        return (T)this;
    }

    public T setLabels(String ... labels) {
        this.labels.clear();
        this.labels.addAll(Arrays.asList(labels));
        return (T)this;
    }

    public T addLabels(Collection<String> labels) {
        this.labels.addAll(labels);
        return (T)this;
    }

    public T addLabels(String ... labels) {
        this.labels.addAll(Arrays.asList(labels));
        return (T)this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public JSONObject toJson() {
        JSONObject chartData = new JSONObject();
        int requiredLabels = this.datasets.stream().mapToInt(d -> d.getData().size()).max().orElse(0);
        if (this.labels.size() >= requiredLabels) {
            chartData.put("labels", this.labels);
        } else {
            ArrayList<String> completeLabels = new ArrayList<String>(this.labels);
            completeLabels.addAll(IntStream.range(this.labels.size(), requiredLabels).mapToObj(d -> "").collect(Collectors.toList()));
            chartData.put("labels", completeLabels);
        }
        if (this.datasets != null) {
            JSONArray chartDatasets = new JSONArray();
            for (ChartDataset<DT, D> genericDataset : this.datasets) {
                chartDatasets.put((Object)genericDataset.toJson());
            }
            chartData.put("datasets", (Object)chartDatasets);
        }
        return chartData;
    }

    public abstract T applyDefaultStylePerDatapoint();

    public abstract T applyDefaultStylePerDataset();
}

