/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.j2chartjs.chart;

import de.yanwittmann.j2chartjs.data.ChartData;
import de.yanwittmann.j2chartjs.options.ChartOptions;
import de.yanwittmann.util.Util;
import org.json.JSONObject;

public abstract class Chart<C, T, DT, D> {
    protected final String typeIdentifier;
    protected ChartData<T, DT, D> chartData;
    protected ChartOptions chartOptions;

    protected Chart(String typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public ChartData<T, DT, D> getChartData() {
        return this.chartData;
    }

    public C setChartData(ChartData<T, DT, D> chartData) {
        this.chartData = chartData;
        return (C)this;
    }

    public ChartOptions getChartOptions() {
        return this.chartOptions;
    }

    public C setChartOptions(ChartOptions chartOptions) {
        this.chartOptions = chartOptions;
        return (C)this;
    }

    private JSONObject toJson() {
        JSONObject chartDefinition = new JSONObject();
        Util.addToJson(chartDefinition, "type", this.typeIdentifier);
        Util.addToJson(chartDefinition, "data", this.chartData);
        Util.addToJson(chartDefinition, "options", this.chartOptions);
        return chartDefinition;
    }

    private String prepareBuild() {
        return this.toJson().toString();
    }

    public String build() {
        return Util.finalizeBuildString(this.prepareBuild());
    }

    public String toString() {
        return this.build();
    }
}

