/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter {
    public static final DateFormat ISO8601_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final DateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateTimeFormatter ORACLE_LIKE_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    public static <T> T convertDate(String string, Class<T> type) {
        return DateConverter.convertDateInternal(string, type, ZoneId.of("UTC"));
    }

    public static <T> T convertDateFallbackToDefaultTimeZone(String string, Class<T> type) {
        return DateConverter.convertDateInternal(string, type, TimeZone.getDefault().toZoneId());
    }

    static <T> T convertDateInternal(String string, Class<T> type, ZoneId fallbackZoneId) {
        if (Date.class.equals(type)) {
            return (T)Date.from(DateConverter.parseInstant(string, fallbackZoneId));
        }
        if (java.sql.Date.class.equals(type)) {
            return (T)java.sql.Date.from(DateConverter.parseInstant(string, fallbackZoneId));
        }
        if (Time.class.equals(type)) {
            return (T)Time.from(DateConverter.parseInstant(string, fallbackZoneId));
        }
        if (Timestamp.class.equals(type)) {
            return (T)Timestamp.from(DateConverter.parseInstant(string, fallbackZoneId));
        }
        if (LocalTime.class.equals(type)) {
            return (T)LocalTime.parse(string);
        }
        if (LocalDate.class.equals(type)) {
            return (T)LocalDate.parse(string);
        }
        if (LocalDateTime.class.equals(type)) {
            return (T)LocalDateTime.parse(string);
        }
        if (ZonedDateTime.class.equals(type)) {
            return (T)ZonedDateTime.parse(string);
        }
        if (OffsetDateTime.class.equals(type)) {
            return (T)OffsetDateTime.parse(string);
        }
        if (OffsetTime.class.equals(type)) {
            return (T)OffsetTime.parse(string);
        }
        return null;
    }

    static Instant parseInstant(String string, ZoneId fallbackZoneId) {
        if (string.contains("T")) {
            TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_DATE_TIME.parse(string);
            if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                return Instant.from(temporalAccessor);
            }
            return LocalDateTime.from(temporalAccessor).atZone(fallbackZoneId).toInstant();
        }
        if (string.contains(" ")) {
            TemporalAccessor temporalAccessor = ORACLE_LIKE_DATE.parse(string);
            return LocalDateTime.from(temporalAccessor).atZone(fallbackZoneId).toInstant();
        }
        TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_DATE.parse(string);
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            return LocalDate.from(temporalAccessor).atTime(0, 0).atOffset(ZoneOffset.from(temporalAccessor)).toInstant();
        }
        return LocalDate.from(temporalAccessor).atTime(0, 0).atZone(fallbackZoneId).toInstant();
    }

    private DateConverter() {
    }
}

