/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.jdbc;

import de.yamass.redg.runtime.AttributeMetaInfo;
import de.yamass.redg.runtime.ExistingEntryMissingException;
import de.yamass.redg.runtime.InsertionFailedException;
import de.yamass.redg.runtime.RedGEntity;
import de.yamass.redg.runtime.transformer.DefaultPreparedStatementParameterSetter;
import de.yamass.redg.runtime.transformer.PreparedStatementParameterSetter;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedGDatabaseUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RedGDatabaseUtil.class);

    private RedGDatabaseUtil() {
    }

    public static void insertDataIntoDatabase(List<? extends RedGEntity> gObjects, Connection connection) {
        RedGDatabaseUtil.insertDataIntoDatabase(gObjects, connection, new DefaultPreparedStatementParameterSetter());
    }

    public static void insertDataIntoDatabase(List<? extends RedGEntity> gObjects, Connection connection, PreparedStatementParameterSetter preparedStatementParameterSetter) {
        Map statementMap = gObjects.stream().filter(RedGDatabaseUtil.distinctByKey((Function<RedGEntity, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lde/yamass/redg/runtime/RedGEntity;)Ljava/lang/Object;)())).collect(HashMap::new, (m, obj) -> m.put(obj.getClass(), RedGDatabaseUtil.prepareStatement(connection).apply((RedGEntity)obj)), HashMap::putAll);
        for (RedGEntity redGEntity : gObjects) {
            PreparedStatement statement = (PreparedStatement)statementMap.get(redGEntity.getClass());
            if (statement == null) {
                throw new InsertionFailedException("Could not get prepared statement for class " + redGEntity.getClass().getName());
            }
            Object[] values = redGEntity.getPreparedStatementValues();
            for (int i = 0; i < values.length; ++i) {
                try {
                    AttributeMetaInfo[] preparedStatementValueMetaInfo = redGEntity.getPreparedStatementValuesMetaInfos();
                    if (values[i] == null) {
                        statement.setNull(i + 1, preparedStatementValueMetaInfo[i].getSqlTypeInt());
                        continue;
                    }
                    preparedStatementParameterSetter.setParameter(statement, i + 1, values[i], preparedStatementValueMetaInfo[i], connection);
                    continue;
                }
                catch (SQLException e) {
                    throw new InsertionFailedException("Setting value for statement failed", e);
                }
            }
            try {
                boolean resultType = statement.execute();
                if (resultType) {
                    ResultSet rs = statement.getResultSet();
                    rs.next();
                    if (rs.getInt(1) != 1) {
                        LOG.error("The entry of type {} was specified as existing (PKs: {}) but could not be found/identified in the database. The test query found {} matches.  If you modelled the searched entity via RedG, you should call findSingleEntity() instead.", new Object[]{redGEntity.getClass(), redGEntity.getPreparedStatementValues(), rs.getInt(1)});
                        throw new ExistingEntryMissingException("The entry of type " + String.valueOf(redGEntity.getClass()) + ", identified by " + Arrays.toString(redGEntity.getPreparedStatementValues()) + " was not found!");
                    }
                } else if (statement.getUpdateCount() != 1) {
                    LOG.warn("Insert statement updated more that one database entry. {} entries were updated", (Object)statement.getUpdateCount());
                }
                statement.clearParameters();
            }
            catch (SQLException e) {
                throw new InsertionFailedException("SQL execution failed", e);
            }
        }
    }

    private static Function<RedGEntity, PreparedStatement> prepareStatement(Connection connection) {
        return gis -> {
            try {
                return connection.prepareStatement(gis.getPreparedStatementString());
            }
            catch (SQLException e) {
                LOG.error("Could not create prepared statement", (Throwable)e);
                return null;
            }
        };
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

