/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.insertvalues;

import de.yamass.redg.runtime.insertvalues.SQLValuesFormatter;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSQLValuesFormatter
implements SQLValuesFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSQLValuesFormatter.class);

    @Override
    public <T> String formatValue(T value, String sqlDataType, String fullTableName, String tableName, String columnName) {
        if (value == null) {
            return "NULL";
        }
        switch (sqlDataType) {
            case "VARCHAR": 
            case "VARCHAR2": {
                return "'" + value.toString().replace("'", "''") + "'";
            }
            case "DECIMAL": 
            case "NUMBER": {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? "1" : "0";
                }
                return value.toString();
            }
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            Timestamp t = new Timestamp(d.getTime());
            return "TO_TIMESTAMP('" + t.toString() + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
        }
        if (value instanceof TemporalAccessor) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)value;
            String s = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S").format(temporalAccessor);
            return "TO_TIMESTAMP('" + s + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
        }
        LOG.warn("No mapping for {}. Returning result of toString()", (Object)sqlDataType);
        return value.toString();
    }
}

