/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.defaultvalues.pluggable.buildermatchers;

import de.yamass.redg.models.ColumnModel;
import java.util.Arrays;
import java.util.function.Predicate;

public class Matchers {
    public static Predicate<ColumnModel> tableName(Predicate<String> condition) {
        return cM -> condition.test(cM.getDbTableName());
    }

    public static Predicate<ColumnModel> fullTableName(Predicate<String> condition) {
        return cM -> condition.test(cM.getDbFullTableName());
    }

    public static Predicate<ColumnModel> columnName(Predicate<String> condition) {
        return cM -> condition.test(cM.getDbName());
    }

    public static Predicate<ColumnModel> type(Predicate<Class<?>> condition) {
        return cM -> condition.test(cM.getJavaTypeAsClass());
    }

    public static Predicate<ColumnModel> notNull(Predicate<Boolean> condition) {
        return cM -> condition.test(cM.isNotNull());
    }

    public static Predicate<ColumnModel> isNotNull() {
        return ColumnModel::isNotNull;
    }

    public static Predicate<ColumnModel> isUnique() {
        return ColumnModel::isUnique;
    }

    public static Predicate<ColumnModel> isPrimary() {
        return ColumnModel::isPartOfPrimaryKey;
    }

    @Deprecated
    public static Predicate<ColumnModel> allOf(Predicate<ColumnModel> ... conditions) {
        return cM -> Arrays.stream(conditions).allMatch(c -> c.test(cM));
    }

    @Deprecated
    public static Predicate<ColumnModel> anyOf(Predicate<ColumnModel> ... conditions) {
        return cM -> Arrays.stream(conditions).anyMatch(c -> c.test(cM));
    }

    public static Predicate<ColumnModel> oneOf(Predicate<ColumnModel> ... conditions) {
        return cM -> Arrays.stream(conditions).map(c -> c.test(cM)).filter(b -> b).count() == 1L;
    }

    private Matchers() {
    }
}

