/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.defaultvalues.pluggable;

import de.yamass.redg.models.ColumnModel;
import de.yamass.redg.runtime.defaultvalues.pluggable.PluggableDefaultValueProvider;
import java.util.regex.Pattern;

public class ConditionalProvider
implements PluggableDefaultValueProvider {
    private final PluggableDefaultValueProvider internalProvider;
    private final Pattern fullTablePattern;
    private final Pattern tablePattern;
    private final Pattern columnPattern;

    public ConditionalProvider(PluggableDefaultValueProvider internalProvider, String fullTableRegex, String tableRegex, String columnRegex) {
        this.internalProvider = internalProvider;
        this.fullTablePattern = fullTableRegex != null ? Pattern.compile(fullTableRegex) : null;
        this.tablePattern = tableRegex != null ? Pattern.compile(tableRegex) : null;
        this.columnPattern = columnRegex != null ? Pattern.compile(columnRegex) : null;
    }

    @Override
    public boolean willProvide(ColumnModel columnModel) {
        if (this.fullTablePattern != null && !this.fullTablePattern.matcher(columnModel.getDbFullTableName()).matches()) {
            return false;
        }
        if (this.tablePattern != null && !this.tablePattern.matcher(columnModel.getDbTableName()).matches()) {
            return false;
        }
        if (this.columnPattern != null && !this.columnPattern.matcher(columnModel.getDbName()).matches()) {
            return false;
        }
        return this.internalProvider.willProvide(columnModel);
    }

    @Override
    public <T> T getDefaultValue(ColumnModel columnModel, Class<T> type) {
        if (this.willProvide(columnModel)) {
            return this.internalProvider.getDefaultValue(columnModel, type);
        }
        return null;
    }
}

