/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.defaultvalues;

import de.yamass.redg.models.ColumnModel;
import de.yamass.redg.runtime.defaultvalues.DefaultValueStrategy;
import de.yamass.redg.runtime.defaultvalues.NoDefaultValueException;
import de.yamass.redg.runtime.defaultvalues.pluggable.AbstractDateProvider;
import de.yamass.redg.runtime.defaultvalues.pluggable.NumberProvider;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDefaultValueStrategy
implements DefaultValueStrategy {
    private final Logger LOG = LoggerFactory.getLogger(DefaultDefaultValueStrategy.class);
    private static final Map<Class<?>, Object> defaultMappings = new HashMap();
    private final Map<String, Long> uniqueCounter = new HashMap<String, Long>();

    @Override
    public <T> T getDefaultValue(ColumnModel columnModel, Class<T> type) {
        if (!columnModel.isNotNull()) {
            return null;
        }
        if (columnModel.isUnique()) {
            long counter = this.uniqueCounter.compute(columnModel.getDbFullTableName() + "." + columnModel.getDbName(), (k, v) -> v == null ? 0L : v + 1L);
            if (type.isEnum()) {
                if (type.getEnumConstants().length == 0) {
                    throw new NoDefaultValueException("Cannot pick a value from an empty enum!");
                }
                if ((long)type.getEnumConstants().length <= counter) {
                    throw new NoDefaultValueException("Cannot generate a unique enum value. No more different enums! If this enum is part of a bigger unique index, you cannot use the DefaultDefaultValueService anymore.");
                }
                return type.getEnumConstants()[(int)counter];
            }
            return this.getUniqueValue(counter, type);
        }
        if (type.isEnum()) {
            if (type.getEnumConstants().length == 0) {
                throw new NoDefaultValueException("Cannot pick a value from an empty enum!");
            }
            return type.getEnumConstants()[0];
        }
        Object defaultValue = defaultMappings.get(type);
        if (defaultValue != null) {
            return (T)defaultValue;
        }
        throw new NoDefaultValueException("No default value for type " + String.valueOf(type));
    }

    private <T> T getUniqueValue(long counter, Class<T> type) {
        if (Number.class.isAssignableFrom(type)) {
            return NumberProvider.convertNumber(new BigDecimal(counter), type);
        }
        if (java.util.Date.class.isAssignableFrom(type) || TemporalAccessor.class.isAssignableFrom(type)) {
            return AbstractDateProvider.convertDate(new java.util.Date(counter), type);
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            if (counter > 1L) {
                throw new NoDefaultValueException("Can only generate 2 unique boolean values. If this boolean is part of a bigger unique index, you cannot use the DefaultDefaultValueService anymore.");
            }
            return (T)new Boolean(counter == 1L);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            if (counter >= 65535L) {
                throw new NoDefaultValueException("Can only generate 65,535 unique char values. If this char is part of a bigger unique index, you cannot use the DefaultDefaultValueService anymore.");
            }
            return (T)new Character((char)(counter + 1L));
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)Long.toString(counter, 36);
        }
        throw new NoDefaultValueException("Could not generate a unique value for type " + type.toString());
    }

    static {
        defaultMappings.put(String.class, "-");
        defaultMappings.put(Character.class, Character.valueOf(' '));
        defaultMappings.put(Character.TYPE, Character.valueOf(' '));
        defaultMappings.put(Boolean.class, false);
        defaultMappings.put(Boolean.TYPE, false);
        defaultMappings.put(BigDecimal.class, new BigDecimal(0));
        defaultMappings.put(Double.class, 0.0);
        defaultMappings.put(Double.TYPE, 0.0);
        defaultMappings.put(Float.class, Float.valueOf(0.0f));
        defaultMappings.put(Float.TYPE, Float.valueOf(0.0f));
        defaultMappings.put(Long.class, 0L);
        defaultMappings.put(Long.TYPE, 0L);
        defaultMappings.put(Integer.class, 0);
        defaultMappings.put(Integer.TYPE, 0);
        defaultMappings.put(Byte.class, (byte)0);
        defaultMappings.put(Byte.TYPE, (byte)0);
        defaultMappings.put(Short.class, (short)0);
        defaultMappings.put(Short.TYPE, (short)0);
        defaultMappings.put(AtomicInteger.class, new AtomicInteger(0));
        defaultMappings.put(AtomicLong.class, new AtomicLong(0L));
        defaultMappings.put(java.util.Date.class, new java.util.Date(0L));
        defaultMappings.put(Date.class, new Date(0L));
        defaultMappings.put(Time.class, new Time(0L));
        defaultMappings.put(Timestamp.class, new Timestamp(0L));
        defaultMappings.put(LocalDate.class, LocalDate.of(1970, 1, 1));
        defaultMappings.put(LocalTime.class, LocalTime.of(0, 0, 0));
        defaultMappings.put(LocalDateTime.class, LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0));
        defaultMappings.put(ZonedDateTime.class, ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC));
        defaultMappings.put(OffsetDateTime.class, OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC));
        defaultMappings.put(OffsetTime.class, OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC));
    }
}

