/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime;

import de.yamass.redg.runtime.AbstractRedG;
import de.yamass.redg.runtime.defaultvalues.DefaultValueStrategy;
import de.yamass.redg.runtime.dummy.DummyFactory;
import de.yamass.redg.runtime.insertvalues.SQLValuesFormatter;
import de.yamass.redg.runtime.transformer.PreparedStatementParameterSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedGBuilder<T extends AbstractRedG> {
    private static Logger LOG = LoggerFactory.getLogger(RedGBuilder.class);
    private T instance;

    public RedGBuilder() {
        try {
            Class<?> clazz = Class.forName("de.yamass.redg.generated.RedG");
            this.instance = (AbstractRedG)clazz.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error("Could not load default RedG class", (Throwable)e);
            throw new RuntimeException("Could not load default RedG class", e);
        }
    }

    public RedGBuilder(Class<T> clazz) {
        try {
            this.instance = (AbstractRedG)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Could not instantiate RedG instance", (Throwable)e);
            throw new RuntimeException("Could not instantiate RedG instance", e);
        }
    }

    public RedGBuilder<T> withDefaultValueStrategy(DefaultValueStrategy strategy) {
        if (this.instance == null) {
            throw new IllegalStateException("Using the builder after build() was called is not allowed!");
        }
        ((AbstractRedG)this.instance).setDefaultValueStrategy(strategy);
        return this;
    }

    public RedGBuilder<T> withPreparedStatementParameterSetter(PreparedStatementParameterSetter setter) {
        if (this.instance == null) {
            throw new IllegalStateException("Using the builder after build() was called is not allowed!");
        }
        ((AbstractRedG)this.instance).setPreparedStatementParameterSetter(setter);
        return this;
    }

    public RedGBuilder<T> withSqlValuesFormatter(SQLValuesFormatter formatter) {
        if (this.instance == null) {
            throw new IllegalStateException("Using the builder after build() was called is not allowed!");
        }
        ((AbstractRedG)this.instance).setSqlValuesFormatter(formatter);
        return this;
    }

    public RedGBuilder<T> withDummyFactory(DummyFactory dummyFactory) {
        if (this.instance == null) {
            throw new IllegalStateException("Using the builder after build() was called is not allowed!");
        }
        ((AbstractRedG)this.instance).setDummyFactory(dummyFactory);
        return this;
    }

    public T build() {
        T inst = this.instance;
        this.instance = null;
        return inst;
    }
}

