/*
 * Copyright Yann Massard
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.yamass.redg.runtime.dummy;

import de.yamass.redg.runtime.AbstractRedG;
import de.yamass.redg.runtime.RedGEntity;

/**
 * The interface for RedG's dummy mechanism.
 *
 * When implementing a custom DummyFactory, {@link DummyFactory#getDummy(AbstractRedG, Class)} has to return valid dummy entities.
 * You should implement a way to recognize your generated dummy entities (preferably by keeping all dummies in a cache and then comparing against this cache),
 * so that {@link DummyFactory#isDummy(RedGEntity)} returns {@code true} for all dummy entities generated by your dummy factory and false otherwise.
 */
public interface DummyFactory {

    <T extends RedGEntity> T getDummy(AbstractRedG redG, Class<T> dummyClass);

    boolean isDummy(RedGEntity entity);
}
