/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.visualization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.yamass.redg.models.ColumnModel;
import de.yamass.redg.models.ForeignKeyColumnModel;
import de.yamass.redg.models.ForeignKeyModel;
import de.yamass.redg.models.TableModel;
import de.yamass.redg.runtime.RedGEntity;
import de.yamass.redg.runtime.visualization.RedGVisualization;
import de.yamass.redg.runtime.visualization.RedGVisualizationField;
import de.yamass.redg.runtime.visualization.RedGVisualizationObject;
import de.yamass.redg.runtime.visualization.RedGVisualizationRelation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class VisualizationUtil {
    public static String getVisualizationJson(List<RedGEntity> entities, Predicate<RedGEntity> dummyTester) {
        RedGVisualization visualization = new RedGVisualization();
        HashMap uuidMap = new HashMap();
        entities.forEach(entity -> {
            UUID uuid = UUID.randomUUID();
            uuidMap.put(entity, uuid);
        });
        for (RedGEntity entity2 : entities) {
            try {
                Method getter;
                UUID uuid = (UUID)uuidMap.get(entity2);
                RedGVisualizationObject object = new RedGVisualizationObject();
                object.setId(uuid.toString());
                Method getTableModel = entity2.getClass().getMethod("getTableModel", new Class[0]);
                TableModel tableModel = (TableModel)getTableModel.invoke(null, new Object[0]);
                object.setType(tableModel.getName());
                object.setSqlName(tableModel.getSqlName());
                object.setExistingEntity(entity2.getClass().getSimpleName().startsWith("Existing"));
                object.setDummy(dummyTester.test(entity2));
                Method getModifiedFields = entity2.getClass().getMethod("getModifiedFields", new Class[0]);
                Set modifiedFields = (Set)getModifiedFields.invoke((Object)entity2, new Object[0]);
                for (ColumnModel column : tableModel.getColumns()) {
                    getter = entity2.getClass().getMethod(column.getName(), new Class[0]);
                    Object value = getter.invoke((Object)entity2, new Object[0]);
                    RedGVisualizationField field = new RedGVisualizationField(column.getName(), column.getDbName(), value != null ? value.toString() : "null");
                    if (modifiedFields.contains(column.getName())) {
                        object.getExplicitFields().add(field);
                        continue;
                    }
                    object.getImplicitFields().add(field);
                }
                for (ForeignKeyModel fkModel : tableModel.getForeignKeys()) {
                    getter = entity2.getClass().getMethod(fkModel.getName(), new Class[0]);
                    RedGEntity refEntity = (RedGEntity)getter.invoke((Object)entity2, new Object[0]);
                    String sqlNames = fkModel.getReferences().values().stream().map(ForeignKeyColumnModel::getDbName).collect(Collectors.joining(", "));
                    RedGVisualizationRelation relation = new RedGVisualizationRelation(uuid.toString(), refEntity != null ? ((UUID)uuidMap.get(refEntity)).toString() : "null", fkModel.getName(), sqlNames);
                    visualization.getRelationships().add(relation);
                }
                visualization.getObjects().add(object);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not process entity", e);
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)visualization);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not generate JSON", e);
        }
    }
}

