/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.dummy;

import de.yamass.redg.runtime.AbstractRedG;
import de.yamass.redg.runtime.RedGEntity;
import de.yamass.redg.runtime.dummy.DummyCreationException;
import de.yamass.redg.runtime.dummy.DummyFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DefaultDummyFactory
implements DummyFactory {
    private final Map<Class<? extends RedGEntity>, RedGEntity> dummyCache = new HashMap<Class<? extends RedGEntity>, RedGEntity>();

    @Override
    public <T extends RedGEntity> T getDummy(AbstractRedG redG, Class<T> dummyClass) {
        if (this.dummyCache.containsKey(dummyClass)) {
            return (T)((RedGEntity)dummyClass.cast(this.dummyCache.get(dummyClass)));
        }
        T obj = this.createNewDummy(redG, dummyClass);
        this.dummyCache.put((Class<? extends RedGEntity>)dummyClass, (RedGEntity)obj);
        return obj;
    }

    @Override
    public boolean isDummy(RedGEntity entity) {
        return this.dummyCache.containsValue(entity);
    }

    private <T extends RedGEntity> T createNewDummy(AbstractRedG redG, Class<T> dummyClass) {
        Constructor constructor = Arrays.stream(dummyClass.getDeclaredConstructors()).filter(this::isDummyRedGEntityConstructor).findFirst().orElseThrow(() -> new DummyCreationException("Could not find a fitting constructor"));
        Object[] parameter = new Object[constructor.getParameterCount()];
        parameter[0] = redG;
        for (int i = 1; i < constructor.getParameterCount(); ++i) {
            parameter[i] = this.getDummy(redG, constructor.getParameterTypes()[i]);
        }
        try {
            constructor.setAccessible(true);
            RedGEntity obj = (RedGEntity)dummyClass.cast(constructor.newInstance(parameter));
            redG.addEntity(obj);
            return (T)obj;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DummyCreationException("Instantiation of the dummy failed", e);
        }
    }

    private boolean isDummyRedGEntityConstructor(Constructor constructor) {
        if (constructor.getParameterCount() < 1) {
            return false;
        }
        if (!AbstractRedG.class.isAssignableFrom(constructor.getParameterTypes()[0])) {
            return false;
        }
        for (int i = 1; i < constructor.getParameterCount(); ++i) {
            if (RedGEntity.class.isAssignableFrom(constructor.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }
}

