/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.defaultvalues.pluggable;

import de.yamass.redg.models.ColumnModel;
import de.yamass.redg.runtime.defaultvalues.pluggable.PluggableDefaultValueProvider;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class NumberProvider
implements PluggableDefaultValueProvider {
    @Override
    public boolean willProvide(ColumnModel columnModel) {
        return Number.class.isAssignableFrom(columnModel.getJavaTypeAsClass());
    }

    public static <T> T convertNumber(BigDecimal number, Class<T> type) {
        if (type == Double.TYPE) {
            type = Double.class;
        } else if (type == Float.TYPE) {
            type = Float.class;
        } else if (type == Long.TYPE) {
            type = Long.class;
        } else if (type == Integer.TYPE) {
            type = Integer.class;
        } else if (type == Byte.TYPE) {
            type = Byte.class;
        } else if (type == Short.TYPE) {
            type = Short.class;
        }
        if (BigDecimal.class.equals(type)) {
            return (T)type.cast(number);
        }
        if (Double.class.equals(type)) {
            return (T)type.cast(number.doubleValue());
        }
        if (Float.class.equals(type)) {
            return (T)type.cast(Float.valueOf(number.floatValue()));
        }
        if (Long.class.equals(type)) {
            return (T)type.cast(number.longValueExact());
        }
        if (Integer.class.equals(type)) {
            return (T)type.cast(number.intValueExact());
        }
        if (Byte.class.equals(type)) {
            return (T)type.cast(number.byteValueExact());
        }
        if (Short.class.equals(type)) {
            return (T)type.cast(number.shortValueExact());
        }
        if (AtomicInteger.class.equals(type)) {
            return (T)type.cast(new AtomicInteger(number.intValueExact()));
        }
        if (AtomicLong.class.equals(type)) {
            return (T)type.cast(new AtomicLong(number.longValueExact()));
        }
        return null;
    }
}

