/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.defaultvalues.pluggable;

import de.yamass.redg.models.ColumnModel;
import de.yamass.redg.runtime.defaultvalues.pluggable.NumberProvider;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class IncrementingNumberProvider
extends NumberProvider {
    private final Map<String, BigDecimal> values = new HashMap<String, BigDecimal>();
    private BigDecimal startValue;

    public IncrementingNumberProvider() {
        this(BigDecimal.ZERO);
    }

    public IncrementingNumberProvider(BigDecimal value) {
        this.startValue = value;
    }

    @Override
    public <T> T getDefaultValue(ColumnModel columnModel, Class<T> type) {
        String key = columnModel.getDbFullTableName() + "." + columnModel.getDbName();
        BigDecimal number = this.values.getOrDefault(key, this.startValue);
        number = number.add(BigDecimal.ONE);
        this.values.put(key, number);
        return IncrementingNumberProvider.convertNumber(number, type);
    }
}

