/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.defaultvalues.pluggable;

import de.yamass.redg.models.ColumnModel;
import de.yamass.redg.runtime.defaultvalues.pluggable.PluggableDefaultValueProvider;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public abstract class AbstractDateProvider
implements PluggableDefaultValueProvider {
    @Override
    public boolean willProvide(ColumnModel columnModel) {
        return Date.class.isAssignableFrom(columnModel.getJavaTypeAsClass()) || TemporalAccessor.class.isAssignableFrom(columnModel.getJavaTypeAsClass());
    }

    public static <T> T convertDate(Date date, Class<T> type) {
        if (Date.class.equals(type)) {
            return type.cast(date);
        }
        if (java.sql.Date.class.equals(type)) {
            return type.cast(new java.sql.Date(date.getTime()));
        }
        if (Time.class.equals(type)) {
            return type.cast(new Time(date.getTime()));
        }
        if (Timestamp.class.equals(type)) {
            return type.cast(new Timestamp(date.getTime()));
        }
        if (LocalTime.class.equals(type)) {
            LocalTime t = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalTime();
            return type.cast(t);
        }
        if (LocalDate.class.equals(type)) {
            LocalDate d = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
            return type.cast(d);
        }
        if (LocalDateTime.class.equals(type)) {
            return type.cast(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
        }
        if (ZonedDateTime.class.equals(type)) {
            return type.cast(ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
        }
        if (OffsetDateTime.class.equals(type)) {
            return type.cast(OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
        }
        if (OffsetTime.class.equals(type)) {
            return type.cast(OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toOffsetTime());
        }
        return null;
    }
}

