/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime.defaultvalues;

import de.yamass.redg.models.ColumnModel;
import de.yamass.redg.runtime.defaultvalues.DefaultValueStrategy;
import de.yamass.redg.runtime.defaultvalues.pluggable.DefaultDefaultValueProvider;
import de.yamass.redg.runtime.defaultvalues.pluggable.PluggableDefaultValueProvider;
import de.yamass.redg.runtime.defaultvalues.pluggable.PluggableDefaultValueStrategy;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class DefaultValueStrategyBuilder {
    private PluggableDefaultValueStrategy pluggableDefaultValueStrategy = new PluggableDefaultValueStrategy();
    private DefaultValueStrategy fallbackStrategy = new DefaultDefaultValueProvider();

    public Condition when(Predicate<ColumnModel> predicate) {
        return new PredicateCondition(predicate);
    }

    public Condition whenTableNameMatches(String regex) {
        return new TableNameRegexCondition(regex);
    }

    public Condition whenColumnNameMatches(String regex) {
        return new ColumnNameRegexCondition(regex);
    }

    public void setFallbackStrategy(DefaultValueStrategy fallbackStrategy) {
        this.fallbackStrategy = fallbackStrategy;
    }

    private void addProvider(final Predicate<ColumnModel> conditionPredicate, final BiFunction<ColumnModel, Class, Object> valueProducer) {
        this.pluggableDefaultValueStrategy.addProvider(new PluggableDefaultValueProvider(){

            @Override
            public boolean willProvide(ColumnModel columnModel) {
                return conditionPredicate.test(columnModel);
            }

            @Override
            public <T> T getDefaultValue(ColumnModel columnModel, Class<T> type) {
                return (T)valueProducer.apply(columnModel, type);
            }
        });
    }

    public DefaultValueStrategy build() {
        this.pluggableDefaultValueStrategy.addProvider(new PluggableDefaultValueProvider(){

            @Override
            public boolean willProvide(ColumnModel columnModel) {
                return true;
            }

            @Override
            public <T> T getDefaultValue(ColumnModel columnModel, Class<T> type) {
                return DefaultValueStrategyBuilder.this.fallbackStrategy.getDefaultValue(columnModel, type);
            }
        });
        return this.pluggableDefaultValueStrategy;
    }

    class PredicateCondition
    extends Condition {
        private final Predicate<ColumnModel> predicate;

        PredicateCondition(Predicate<ColumnModel> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean evaluate(ColumnModel columnModel) {
            return this.predicate.test(columnModel);
        }
    }

    class TableNameRegexCondition
    extends Condition {
        private final Pattern pattern;

        TableNameRegexCondition(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean evaluate(ColumnModel columnModel) {
            return this.pattern.matcher(columnModel.getDbTableName()).matches();
        }
    }

    class ColumnNameRegexCondition
    extends Condition {
        private final Pattern pattern;

        ColumnNameRegexCondition(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean evaluate(ColumnModel columnModel) {
            return this.pattern.matcher(columnModel.getDbName()).matches();
        }
    }

    class AndCondition
    extends Condition {
        private final Condition condition1;
        private final Condition condition2;

        public AndCondition(Condition condition1, Condition condition2) {
            this.condition1 = condition1;
            this.condition2 = condition2;
        }

        @Override
        public boolean evaluate(ColumnModel columnModel) {
            return this.condition1.evaluate(columnModel) && this.condition2.evaluate(columnModel);
        }
    }

    public abstract class Condition {
        public abstract boolean evaluate(ColumnModel var1);

        public void thenUse(Object staticValue) {
            DefaultValueStrategyBuilder.this.addProvider(this::evaluate, (columnModel, aClass) -> staticValue);
        }

        public void thenCompute(BiFunction<ColumnModel, Class, Object> computationFunction) {
            DefaultValueStrategyBuilder.this.addProvider(this::evaluate, computationFunction);
        }

        public void thenUseProvider(PluggableDefaultValueProvider provider) {
            DefaultValueStrategyBuilder.this.addProvider(columnModel -> this.evaluate((ColumnModel)columnModel) && provider.willProvide((ColumnModel)columnModel), provider::getDefaultValue);
        }

        public Condition and(Predicate<ColumnModel> predicate) {
            return new AndCondition(this, new PredicateCondition(predicate));
        }

        public Condition andTableNameMatches(String regex) {
            return new AndCondition(this, new TableNameRegexCondition(regex));
        }

        public Condition andColumnNameMatches(String regex) {
            return new AndCondition(this, new ColumnNameRegexCondition(regex));
        }
    }
}

