/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime;

import de.yamass.redg.runtime.RedGEntity;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EntitySorter {
    public static List<RedGEntity> sortEntities(List<RedGEntity> entities) {
        Map<RedGEntity, Integer> depths = new DepthCalculator().calculateDepths(entities);
        return entities.stream().sorted(Comparator.comparing(EntitySorter::isExisting).reversed().thenComparingInt(depths::get)).collect(Collectors.toList());
    }

    private static boolean isExisting(RedGEntity entity) {
        return entity.getClass().getSimpleName().startsWith("Existing");
    }

    private static class DepthCalculator {
        Map<RedGEntity, Integer> depths;

        private DepthCalculator() {
        }

        Map<RedGEntity, Integer> calculateDepths(List<RedGEntity> entities) {
            this.depths = new HashMap<RedGEntity, Integer>();
            entities.forEach(this::calculateDepth);
            return this.depths;
        }

        private int calculateDepth(RedGEntity entity) {
            if (this.depths.containsKey(entity)) {
                return this.depths.get(entity);
            }
            if (entity.getDependencies() == null || entity.getDependencies().size() == 0) {
                this.depths.put(entity, 0);
                return 0;
            }
            int maxDepth = 0;
            for (RedGEntity childEntity : entity.getDependencies()) {
                if (childEntity == entity) {
                    maxDepth = Math.max(maxDepth, 0);
                    continue;
                }
                maxDepth = Math.max(maxDepth, this.calculateDepth(childEntity));
            }
            this.depths.put(entity, ++maxDepth);
            return maxDepth;
        }
    }
}

