/*
 * Decompiled with CFR 0.152.
 */
package de.yamass.redg.runtime;

import de.yamass.redg.runtime.EntitySorter;
import de.yamass.redg.runtime.RedGEntity;
import de.yamass.redg.runtime.defaultvalues.DefaultDefaultValueStrategy;
import de.yamass.redg.runtime.defaultvalues.DefaultValueStrategy;
import de.yamass.redg.runtime.dummy.DefaultDummyFactory;
import de.yamass.redg.runtime.dummy.DummyFactory;
import de.yamass.redg.runtime.insertvalues.DefaultSQLValuesFormatter;
import de.yamass.redg.runtime.insertvalues.SQLValuesFormatter;
import de.yamass.redg.runtime.jdbc.RedGDatabaseUtil;
import de.yamass.redg.runtime.transformer.DefaultPreparedStatementParameterSetter;
import de.yamass.redg.runtime.transformer.PreparedStatementParameterSetter;
import java.sql.Connection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractRedG {
    private DefaultValueStrategy defaultValueStrategy = new DefaultDefaultValueStrategy();
    private SQLValuesFormatter sqlValuesFormatter = new DefaultSQLValuesFormatter();
    private PreparedStatementParameterSetter preparedStatementParameterSetter = new DefaultPreparedStatementParameterSetter();
    private DummyFactory dummyFactory = new DefaultDummyFactory();
    private List<RedGEntity> entities = new LinkedList<RedGEntity>();

    public void addEntity(RedGEntity entity) {
        this.entities.add(entity);
    }

    public DefaultValueStrategy getDefaultValueStrategy() {
        return this.defaultValueStrategy;
    }

    public void setDefaultValueStrategy(DefaultValueStrategy defaultValueStrategy) {
        if (this.entities.size() > 0) {
            throw new IllegalStateException("The default value strategy cannot be changed after an entity was generated!");
        }
        this.defaultValueStrategy = defaultValueStrategy == null ? new DefaultDefaultValueStrategy() : defaultValueStrategy;
    }

    public SQLValuesFormatter getSqlValuesFormatter() {
        return this.sqlValuesFormatter;
    }

    public void setSqlValuesFormatter(SQLValuesFormatter sqlValuesFormatter) {
        if (this.entities.size() > 0) {
            throw new IllegalStateException("The SQL values formatter cannot be changed after an entity was generated!");
        }
        this.sqlValuesFormatter = sqlValuesFormatter == null ? new DefaultSQLValuesFormatter() : sqlValuesFormatter;
    }

    public PreparedStatementParameterSetter getPreparedStatementParameterSetter() {
        return this.preparedStatementParameterSetter;
    }

    public void setPreparedStatementParameterSetter(PreparedStatementParameterSetter preparedStatementParameterSetter) {
        if (this.entities.size() > 0) {
            throw new IllegalStateException("The PreparedStatement parameter setter cannot be changed after an entity was generated!");
        }
        this.preparedStatementParameterSetter = preparedStatementParameterSetter == null ? new DefaultPreparedStatementParameterSetter() : preparedStatementParameterSetter;
    }

    public DummyFactory getDummyFactory() {
        return this.dummyFactory;
    }

    public void setDummyFactory(DummyFactory dummyFactory) {
        if (this.entities.size() > 0) {
            throw new IllegalStateException("The dummy factory cannot be changed after an entity was generated!");
        }
        this.dummyFactory = dummyFactory == null ? new DefaultDummyFactory() : dummyFactory;
    }

    public List<String> generateSQLStatements() {
        return this.getEntitiesSortedForInsert().stream().map(RedGEntity::getSQLString).collect(Collectors.toList());
    }

    public void insertDataIntoDatabase(Connection connection) {
        RedGDatabaseUtil.insertDataIntoDatabase(this.getEntitiesSortedForInsert(), connection, this.preparedStatementParameterSetter);
    }

    public <T extends RedGEntity> T findSingleEntity(Class<T> type, Predicate<T> filter) {
        return (T)this.entities.stream().filter(obj -> Objects.equals(type, obj.getClass())).map(type::cast).filter(filter).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find an entity that satisfies the filter!"));
    }

    public <T extends RedGEntity> List<T> findEntities(Class<T> type, Predicate<T> filter) {
        return this.entities.stream().filter(obj -> Objects.equals(type, obj.getClass())).map(type::cast).filter(filter).collect(Collectors.toList());
    }

    public List<RedGEntity> getEntities() {
        return Collections.unmodifiableList(this.entities);
    }

    public List<RedGEntity> getEntitiesSortedForInsert() {
        return EntitySorter.sortEntities(this.entities);
    }

    public abstract String getVisualizationJson();
}

