/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import de.xam.featdoc.Util;
import de.xam.featdoc.markdown.MarkdownTool;
import de.xam.featdoc.markdown.StringTree;
import de.xam.featdoc.mermaid.sequence.Arrow;
import de.xam.featdoc.mermaid.sequence.SequenceDiagram;
import de.xam.featdoc.system.Condition;
import de.xam.featdoc.system.Feature;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.ResultStep;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Timing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Universe {
    private final List<Scenario> scenarios = new ArrayList<Scenario>();
    private final List<System> systems = new ArrayList<System>();
    private final List<Condition> conditions = new ArrayList<Condition>();

    public List<ResultStep> computeResultingSteps(Scenario scenario) {
        ArrayList<ResultStep> resultingSteps = new ArrayList<ResultStep>();
        for (ScenarioStep step : scenario.steps()) {
            this.reactOn(step, resultingSteps::add);
        }
        return resultingSteps;
    }

    public Condition condition(String label) {
        return Util.add(this.conditions, new Condition(label));
    }

    public Stream<Feature> featuresProducing(Message message) {
        return this.systems.stream().flatMap(system -> system.features().stream()).filter(feature -> feature.isProducing(message));
    }

    public void forEachEdge(BiConsumer<System, System> source_target) {
        this.scenarios().stream().flatMap(scenario -> scenario.steps().stream()).forEach(scenarioStep -> source_target.accept(scenarioStep.sourceSystem(), scenarioStep.message().system()));
        this.systems().stream().flatMap(System::rules).forEach(rule -> rule.actions().forEach(target -> source_target.accept(rule.trigger().message().system(), target.message().system())));
    }

    public Scenario scenario(String title) {
        return Util.add(this.scenarios, new Scenario(this, title));
    }

    public Stream<ScenarioStep> scenarioStepsProducing(Message message) {
        return this.scenarios.stream().flatMap(scenario -> scenario.steps().stream()).filter(scenarioStep -> scenarioStep.message().equals(message));
    }

    public List<Scenario> scenarios() {
        return this.scenarios;
    }

    public System system(String id, String name, String wikiName) {
        return Util.add(this.systems, new System(id, name, wikiName, 0));
    }

    public System system(String id, String name, String wikiName, int sortOrder) {
        return Util.add(this.systems, new System(id, name, wikiName, sortOrder));
    }

    public List<System> systems() {
        return Collections.unmodifiableList(this.systems);
    }

    public Stream<System> systemsCalledFrom(System system) {
        TreeMultimap systemSystemMap = TreeMultimap.create();
        this.forEachEdge((arg_0, arg_1) -> ((SetMultimap)systemSystemMap).put(arg_0, arg_1));
        Set targets = systemSystemMap.get((Object)system);
        return targets.stream().sorted();
    }

    public Stream<System> systemsCalling(System system) {
        TreeMultimap systemSystemMap = TreeMultimap.create();
        this.forEachEdge((arg_0, arg_1) -> ((SetMultimap)systemSystemMap).put(arg_0, arg_1));
        return systemSystemMap.entries().stream().filter(e -> ((System)e.getValue()).equals(system)).map(Map.Entry::getKey).sorted();
    }

    public Stream<System> systemsProducing(Message message) {
        return this.systems.stream().filter(system -> system.isProducing(message));
    }

    public SequenceDiagram toSequence(Scenario scenario) {
        List<ResultStep> resultingSteps = this.computeResultingSteps(scenario);
        SequenceDiagram sequenceDiagram = new SequenceDiagram(scenario.label());
        resultingSteps.stream().flatMap(rs -> Stream.of(rs.sourceSystem(), rs.targetSystem())).distinct().sorted().forEach(system -> sequenceDiagram.participant(system.id, system.label));
        resultingSteps.forEach(step -> sequenceDiagram.step(step.sourceSystem().id, step.message().timing() == Timing.Synchronous ? Arrow.SolidWithHead : Arrow.DottedAsync, step.targetSystem().id, MarkdownTool.format(step.message().name() + (String)(step.feature() == null ? "" : " [" + step.feature().label + "]"))));
        return sequenceDiagram;
    }

    public List<StringTree> toTrees(Scenario scenario, Function<ResultStep, String> toMarkdown) {
        LinkedList<StringTree> stack = new LinkedList<StringTree>();
        StringTree root = new StringTree("ROOT Szenario: " + scenario.label());
        stack.add(root);
        List<ResultStep> resultingSteps = this.computeResultingSteps(scenario);
        int depth = 0;
        for (ResultStep rs : resultingSteps) {
            int delta = depth - rs.depth();
            if (delta > 0) {
                for (int i = 0; i < delta; ++i) {
                    stack.pop();
                    --depth;
                }
            }
            StringTree child = ((StringTree)stack.peek()).addChild(toMarkdown.apply(rs));
            stack.push(child);
            ++depth;
        }
        ArrayList<StringTree> trees = new ArrayList<StringTree>();
        root.getChildNodesIterator().forEachRemaining(trees::add);
        return trees;
    }

    private Stream<Rule> rules() {
        return this.systems().stream().flatMap(System::rules);
    }

    private void reactOn(ScenarioStep step, Consumer<ResultStep> resultConsumer) {
        ResultStep initialStep = ResultStep.direct(step, 0, step.sourceSystem(), step.message(), step.commentOnMessage(), step.message().isIncoming() ? step.message().system() : null);
        this.reactOn(initialStep, resultConsumer);
    }

    private void reactOn(ResultStep input, Consumer<ResultStep> resultConsumer) {
        AtomicBoolean isAnyRuleTriggered = new AtomicBoolean(false);
        this.rules().forEach(rule -> {
            if (rule.trigger().isTriggeredBy(input.message())) {
                isAnyRuleTriggered.set(true);
                ResultStep inputAndTriggerStep = ResultStep.indirect(input.scenarioStep(), input.depth(), input.sourceSystem(), input.message(), Universe.combineComments(input.messageComment(), rule.trigger().comment()), rule.feature().system(), rule);
                resultConsumer.accept(inputAndTriggerStep);
                for (Rule.Action action : rule.actions()) {
                    ResultStep outputStep = ResultStep.indirect(input.scenarioStep(), input.depth() + 1, rule.feature().system(), action.message(), action.comment(), action.message().isIncoming() ? action.message().system() : null, rule);
                    this.reactOn(outputStep, resultConsumer);
                }
            }
        });
        if (!isAnyRuleTriggered.get()) {
            resultConsumer.accept(input);
        }
    }

    @Nullable
    private static String combineComments(@Nullable String scenarioOrActionComment, @Nullable String ruleTriggerComment) {
        if (scenarioOrActionComment == null) {
            if (ruleTriggerComment == null) {
                return null;
            }
            return String.format("Trigger: %s", ruleTriggerComment);
        }
        if (ruleTriggerComment == null) {
            return null;
        }
        return String.format("%s / Trigger: %s", scenarioOrActionComment, ruleTriggerComment);
    }

    public Stream<Feature> features() {
        return this.systems().stream().flatMap(system -> system.featureList.stream());
    }

    public void validate() {
        this.features().forEach(feature -> {
            if (feature.hasUnfinishedRules()) {
                throw new IllegalStateException(String.format("System '%s' in feature '%s' has an unfinished rule. Likely you forgot to call 'build()'.", feature.system().label, feature.label));
            }
        });
    }
}

