/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Timing;

public record Message(System system, Direction direction, Timing timing, String name) {
    public static Message create(System system, Kind kind, String label) {
        return new Message(system, kind.direction, kind.timing, label);
    }

    public boolean isAsynchronous() {
        return this.timing() == Timing.Asynchronous;
    }

    public boolean isOutgoing() {
        return this.direction() == Direction.OUTGOING;
    }

    public boolean isIncoming() {
        return this.direction() == Direction.INCOMING;
    }

    public boolean isSynchronous() {
        return this.timing() == Timing.Synchronous;
    }

    @Override
    public String toString() {
        return this.system + "-" + this.name + "(" + (this.timing() == Timing.Synchronous ? "sync" : "async") + ")";
    }

    public static enum Direction {
        INCOMING,
        OUTGOING;

    }

    public static enum Kind {
        API_CALL(Direction.INCOMING, Timing.Synchronous),
        WEB_HOOK(Direction.OUTGOING, Timing.Synchronous),
        EVENT_OUTGOING(Direction.OUTGOING, Timing.Asynchronous),
        EVENT_INCOMING(Direction.INCOMING, Timing.Asynchronous),
        UI_INPUT(Direction.INCOMING, Timing.Synchronous),
        UI_OUTPUT(Direction.OUTGOING, Timing.Synchronous);

        private final Direction direction;
        private final Timing timing;

        public Timing timing() {
            return this.timing;
        }

        public Direction direction() {
            return this.direction;
        }

        private Kind(Direction direction, Timing timing) {
            this.direction = direction;
            this.timing = timing;
        }
    }
}

