/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.mermaid.flowchart;

import de.xam.featdoc.LineWriter;
import de.xam.featdoc.mermaid.flowchart.INode;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public record Node(String id, Shape shape, @Nullable String label) implements INode
{
    @Override
    public Optional<String> text() {
        return Optional.ofNullable(this.label);
    }

    @Override
    public void toMermaidSyntax(LineWriter lineWriter) {
        if (this.text().isPresent()) {
            lineWriter.writeLine(this.id() + this.shape().mermaidStart() + "\"" + this.text().get() + "\"" + this.shape().mermaidEnd(), new String[0]);
        }
    }

    static enum Shape {
        Box("[", "]"),
        Rounded("(", ")"),
        Pill("([", "])"),
        Subroutine("[[", "]]"),
        Cylinder("[(", ")]"),
        Circle("((", "))"),
        Asym(">", "]"),
        Rhombus("{", "}"),
        Hexagon("{{", "}}"),
        Parallelogram("[/", "/]"),
        ParallelogramAlt("[\\", "\\]"),
        Trapezoid("[/", "\\]"),
        TrapezoidAlt("[\\", "/]"),
        DoubleCircle("(((", ")))");

        private final String[] mermaid;

        private Shape(String ... mermaid) {
            this.mermaid = mermaid;
        }

        String mermaidEnd() {
            return this.mermaid[1];
        }

        String mermaidStart() {
            return this.mermaid[0];
        }
    }
}

