/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.mermaid;

import de.xam.featdoc.LineWriter;
import de.xam.featdoc.mermaid.MermaidDsl;
import de.xam.featdoc.mermaid.MermaidTool;
import de.xam.featdoc.mermaid.flowchart.FlowchartDiagram;
import de.xam.featdoc.mermaid.flowchart.Node;
import de.xam.featdoc.mermaid.sequence.Arrow;
import de.xam.featdoc.mermaid.sequence.Note;
import de.xam.featdoc.mermaid.sequence.SequenceDiagram;
import de.xam.featdoc.mermaid.sequence.SequenceStep;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.junit.jupiter.api.Test;

class MermaidToolTest {
    MermaidToolTest() {
    }

    @Test
    void testFlowchart() throws IOException {
        FlowchartDiagram flowchartDiagram = MermaidDsl.flowchart((String)"a,b,c");
        Node a1 = flowchartDiagram.node("a1");
        Node a2 = flowchartDiagram.node("a2");
        Node b1 = flowchartDiagram.node("b1");
        Node b2 = flowchartDiagram.node("b2");
        Node c1 = flowchartDiagram.node("c1");
        Node c2 = flowchartDiagram.node("c2");
        flowchartDiagram.edge(c1, a2).subgraph("one").edge(a1, a2).end().subgraph("one").edge(a1, a2).end().subgraph("two").edge(b1, b2).end().subgraph("three").edge(c1, c2).end().edge("one", "two").edge("three", "two").edge("two", "c2");
        PrintWriter w = new PrintWriter(System.out);
        MermaidTool.generateMermaidSyntax((FlowchartDiagram)flowchartDiagram, (LineWriter)LineWriter.wrap((Writer)w));
        ((Writer)w).flush();
        System.out.flush();
    }

    @Test
    void testSequenceDiagram1() throws IOException {
        SequenceDiagram sequenceDiagram = MermaidDsl.sequence((String)"Alice calls John").participant("Alice").participant("John").note(Note.Position.RightOf, "Alice", "Alice calls John.").step("Alice", Arrow.SolidWithHead, SequenceStep.LifetimeEvent.Activate, "John", "Hello John, how are you?").step("Alice", Arrow.SolidWithHead, SequenceStep.LifetimeEvent.Activate, "John", "John, can you hear me?").step("John", Arrow.DottedWithHead, SequenceStep.LifetimeEvent.Deactivate, "Alice", "Hi Alice, I can hear you!").step("John", Arrow.DottedWithHead, SequenceStep.LifetimeEvent.Deactivate, "Alice", "I feel great!").step("Alice", Arrow.SolidWithHead, SequenceStep.LifetimeEvent.Activate, "John", "Did you want to go to the game tonight?").step("John", Arrow.DottedWithHead, SequenceStep.LifetimeEvent.Deactivate, "Alice", "Yeah! See you there.");
        try (PrintWriter w = new PrintWriter(System.out);){
            MermaidTool.generateMermaidSyntax((SequenceDiagram)sequenceDiagram, (LineWriter)LineWriter.wrap((Writer)w));
            ((Writer)w).flush();
        }
    }
}

