/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.example;

import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Universe;

public class RestaurantSystemsAndScenarios {
    public static void defineScenarios() {
        Systems.UNIVERSE.scenario("Lunch-Customer (in a hurry)").step(Systems.CUSTOMER, Waiter.orderEspresso).step(Systems.CUSTOMER, Waiter.customerWantsToPay, "Today no credit cards");
    }

    public static void defineSystems() {
        MobileOrderClient.define();
        Waiter.define();
        CoffeeMachine.define();
        PosSystem.define();
        AccountingSystem.define();
    }

    static interface Systems {
        public static final Universe UNIVERSE = new Universe();
        public static final System CUSTOMER = UNIVERSE.system("customer", "Customer", "Customer");
        public static final System WAITER = UNIVERSE.system("waiter", "Waiter", "Waiter");
        public static final System CM = UNIVERSE.system("coffee", "Coffee Machine", "CoffeeMachine");
        public static final System MOC = UNIVERSE.system("moc", "Mobile Order Client", "Mobile");
        public static final System POS = UNIVERSE.system("pos", "Point of Sale System", "POS");
        public static final System ACC = UNIVERSE.system("accounting", "Accounting System", "Accounting");
    }

    static interface Waiter {
        public static final Message orderEspresso = Systems.WAITER.apiCall("Order Espresso");
        public static final Message orderEspressoDouble = Systems.WAITER.apiCall("Order Double Espresso");
        public static final Message orderCappuccino = Systems.WAITER.apiCall("Order Cappuccino");
        public static final Message customerWantsToPay = Systems.WAITER.apiCall("Customer wants to pay");

        public static void define() {
            Systems.WAITER.feature("Coffee Serving").rule(orderEspresso, CoffeeMachine.espresso, new Message[]{MobileOrderClient.createOrder, MobileOrderClient.addItemToOrder}).rule(customerWantsToPay, MobileOrderClient.createBill, new Message[]{Customer.receiveBill});
        }
    }

    static interface MobileOrderClient {
        public static final Message createOrder = Systems.MOC.uiInput("Create Order");
        public static final Message addItemToOrder = Systems.MOC.uiInput("Add item to running order");
        public static final Message createBill = Systems.MOC.apiCall("Create bill");

        public static void define() {
            Systems.MOC.feature("Mobile Orders").rule(createOrder, PosSystem.searchOrdersForTable, new Message[]{PosSystem.createOrder}).rule(addItemToOrder, PosSystem.addItemToOrder, new Message[0]);
        }
    }

    static interface CoffeeMachine {
        public static final Message espresso = Systems.CM.apiCall("Make an espresso");
        public static final Message espressoDouble = Systems.CM.apiCall("Make a double espresso");
        public static final Message cappuccino = Systems.CM.apiCall("Make a cappuccino");
        public static final Message eventBeansConsumed = Systems.CM.asyncEventOutgoing("20g of coffee beans consumed");
        public static final Message eventMilkConsumed = Systems.CM.asyncEventOutgoing("milk consumed");

        public static void define() {
            Systems.CM.feature("Coffee Making").rule(espresso, "100% Arabica").action(eventBeansConsumed, "Or error on missing beans").build().rule(espressoDouble, eventBeansConsumed, new Message[]{eventBeansConsumed}).rule(cappuccino, eventBeansConsumed, new Message[]{eventMilkConsumed});
        }
    }

    static interface PosSystem {
        public static final Message createOrder = Systems.POS.apiCall("Create order for table");
        public static final Message searchOrdersForTable = Systems.POS.apiCall("Search order of given table");
        public static final Message addItemToOrder = Systems.POS.apiCall("Add item");
        public static final Message addTaxesToOrder = Systems.POS.apiCall("Add taxes");

        public static void define() {
            Systems.POS.feature("Tax Integration").rule(addItemToOrder, AccountingSystem.calculateTax, new Message[]{addTaxesToOrder});
        }
    }

    static interface AccountingSystem {
        public static final Message calculateTax = Systems.ACC.apiCall("Calculate taxes");
        public static final Message reduceInventory = Systems.ACC.apiCall("Reduce inventory");

        public static void define() {
            Systems.ACC.feature("Inventory").rule(CoffeeMachine.eventBeansConsumed, reduceInventory, new Message[0]).rule(CoffeeMachine.eventMilkConsumed, reduceInventory, new Message[0]);
        }
    }

    static interface Customer {
        public static final Message receiveBill = Systems.CUSTOMER.asyncEventIncoming("Receive bill");
    }
}

