/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.mermaid.sequence;

import de.xam.featdoc.markdown.MarkdownTool;
import de.xam.featdoc.mermaid.sequence.Arrow;
import de.xam.featdoc.mermaid.sequence.MermaidDiagram;
import de.xam.featdoc.mermaid.sequence.Note;
import de.xam.featdoc.mermaid.sequence.Participant;
import de.xam.featdoc.mermaid.sequence.SequenceStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SequenceDiagram
implements MermaidDiagram {
    public boolean isAutonumber = false;
    private List<SequenceStep> sequenceSteps = new ArrayList<SequenceStep>();
    private List<Participant> participants = new ArrayList<Participant>();
    private List<Note> notes = new ArrayList<Note>();
    private String title;

    public SequenceDiagram(String title) {
        this.title = title;
    }

    public SequenceDiagram actor(String id) {
        this.participants.add(Participant.actor(id));
        return this;
    }

    public SequenceDiagram actor(String id, String label) {
        this.participants.add(Participant.actor(id, label));
        return this;
    }

    public String filename() {
        return MarkdownTool.filename(this.title);
    }

    public SequenceDiagram note(Note.Position position, String participant, String text) {
        this.notes.add(Note.actorNote(position, participant, text));
        return this;
    }

    public SequenceDiagram note(String participantStart, String participantEnd, String text) {
        this.notes.add(Note.actorsNote(text, participantStart, participantEnd));
        return this;
    }

    public List<Note> notes() {
        return Collections.unmodifiableList(this.notes);
    }

    public SequenceDiagram participant(String id) {
        this.participants.add(Participant.participant(id));
        return this;
    }

    public SequenceDiagram participant(String id, String label) {
        this.participants.add(Participant.participant(id, label));
        return this;
    }

    public SequenceDiagram participants(Participant ... participants) {
        this.participants.addAll(List.of(participants));
        return this;
    }

    public List<Participant> participants() {
        return Collections.unmodifiableList(this.participants);
    }

    public SequenceDiagram step(String fromParticipant, Arrow arrow, SequenceStep.LifetimeEvent lifetimeEvent, String toParticipant, String message, String comment) {
        this.sequenceSteps.add(new SequenceStep(fromParticipant, arrow, lifetimeEvent, toParticipant, message, comment));
        return this;
    }

    public SequenceDiagram step(String fromParticipant, Arrow arrow, String toParticipant, String message) {
        return this.step(fromParticipant, arrow, SequenceStep.LifetimeEvent.None, toParticipant, message, null);
    }

    public SequenceDiagram step(String fromParticipant, SequenceStep.LifetimeEvent lifetimeEvent, String toParticipant, String message) {
        return this.step(fromParticipant, Arrow.SolidWithHead, lifetimeEvent, toParticipant, message, null);
    }

    public SequenceDiagram step(String fromParticipant, String toParticipant, String message) {
        return this.step(fromParticipant, Arrow.SolidWithHead, SequenceStep.LifetimeEvent.None, toParticipant, message, null);
    }

    public SequenceDiagram step(String fromParticipant, Arrow arrow, SequenceStep.LifetimeEvent lifetimeEvent, String toParticipant, String message) {
        return this.step(fromParticipant, arrow, lifetimeEvent, toParticipant, message, null);
    }

    public List<SequenceStep> steps() {
        return Collections.unmodifiableList(this.sequenceSteps);
    }

    public String title() {
        return this.title;
    }

    public SequenceDiagram title(String title) {
        this.title = title;
        return this;
    }
}

