/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.mermaid.flowchart;

import org.jetbrains.annotations.Nullable;

public record Edge(String source, Arrow arrow, @Nullable String label, String target) {
    public String toMermaidSyntax() {
        return this.source() + " " + this.arrow.toMermaidSyntax() + (String)(this.label == null ? "" : "|\"" + this.label + "\"|") + " " + this.target();
    }

    public record Arrow(Start start, Line line, int length, End end) {
        public static Arrow standard() {
            return new Arrow(Start.None, Line.Normal, 1, End.Arrow);
        }

        public String toMermaidSyntax() {
            int len;
            Object s = "";
            int i = len;
            for (len = this.start.mermaid.length() + this.end.mermaid.length(); len < this.length + 2; ++len) {
                s = (String)s + this.line.mermaid;
            }
            s = this.start.mermaid + (String)s + (this.line == Line.Dotted && this.end == End.Arrow ? "->" : this.end.mermaid);
            return s;
        }
    }

    public static enum End {
        Arrow(">"),
        Circle("o"),
        Cross("x"),
        None("-");

        final String mermaid;

        private End(String mermaid) {
            this.mermaid = mermaid;
        }
    }

    public static enum Line {
        Normal("-"),
        Thick("="),
        Dotted(".");

        final String mermaid;

        private Line(String mermaid) {
            this.mermaid = mermaid;
        }
    }

    public static enum Start {
        Arrow("<"),
        Circle("o"),
        Cross("x"),
        None("");

        final String mermaid;

        private Start(String mermaid) {
            this.mermaid = mermaid;
        }
    }
}

