/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc;

import de.xam.featdoc.markdown.MarkdownTool;
import java.io.IOException;
import java.io.Writer;

public interface LineWriter {
    public static LineWriter wrap(Writer w) {
        return (string, args) -> {
            try {
                if (args == null || args.length == 0) {
                    w.write(string);
                } else {
                    w.write(String.format(string, args));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    default public void writeSection(String sectionTitle, String ... args) {
        this.writeLine("", new String[0]);
        this.writeLine("## %s", String.format(sectionTitle, args));
        this.writeLine("", new String[0]);
    }

    default public void writeSection1(String section1Title, String ... args) {
        this.writeLine("## %s", String.format(section1Title, args));
        this.writeLine("", new String[0]);
    }

    default public void writeToc() {
        this.writeLine("", new String[0]);
        this.writeLine("[[_TOC_]]", new String[0]);
        this.writeLine("", new String[0]);
    }

    public void write(String var1, String ... var2);

    default public void writeLine(String line, String ... args) {
        this.write(line, args);
        this.write("\n", new String[0]);
    }

    default public MarkdownTool.Table table() {
        return new MarkdownTool.Table(this);
    }
}

