/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc;

import de.xam.featdoc.annotations.FeatDoc;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatDocAnnotationTool {
    private static final Logger log = LoggerFactory.getLogger(FeatDocAnnotationTool.class);

    public static void scan(String[] packageRoots) {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(packageRoots).ignoreClassVisibility().ignoreFieldVisibility().ignoreMethodVisibility().scan();){
            String name;
            FeatDoc featDoc;
            AnnotationInfo annotationInfo;
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(FeatDoc.class)) {
                AnnotationInfo annotationInfo2 = classInfo.getAnnotationInfo(FeatDoc.class);
                FeatDoc featDoc2 = (FeatDoc)annotationInfo2.loadClassAndInstantiate();
                String name2 = featDoc2.name();
                log.info("C feature name " + name2 + " -- defined in " + classInfo.getName());
            }
            for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(FeatDoc.class)) {
                for (MethodInfo mi : classInfo.getMethodInfo()) {
                    annotationInfo = mi.getAnnotationInfo(FeatDoc.class);
                    if (annotationInfo == null) continue;
                    featDoc = (FeatDoc)annotationInfo.loadClassAndInstantiate();
                    name = featDoc.name();
                    log.info("M feature name " + name + " -- defined in " + classInfo.getName() + "." + mi.getName());
                }
            }
            for (ClassInfo classInfo : scanResult.getClassesWithFieldAnnotation(FeatDoc.class)) {
                for (FieldInfo fi : classInfo.getFieldInfo()) {
                    annotationInfo = fi.getAnnotationInfo(FeatDoc.class);
                    if (annotationInfo == null) continue;
                    featDoc = (FeatDoc)annotationInfo.loadClassAndInstantiate();
                    name = featDoc.name();
                    log.info("M feature name " + name + " -- defined in " + classInfo.getName() + "." + fi.getName());
                }
            }
        }
    }
}

