/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.ResultStep;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Universe;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UniverseTest {
    Universe universe = new Universe();
    System systemSource = this.universe.system("sourceSystem", "Source", "sysSource");
    System systemA = this.universe.system("sysa", "A", "sysAAAAAA");
    System systemB = this.universe.system("sysb", "B", "sysBBBBBB");
    System systemC = this.universe.system("sysc", "C", "sysCCCCCC");
    System systemSink = this.universe.system("sink", "Sink", "sys__Sink");
    Message systemA_event = this.systemA.asyncEventOutgoing("a-event");
    Message systemA_call = this.systemA.apiCall("a-call");
    Message systemB_event = this.systemB.asyncEventOutgoing("b-event");
    Message systemB_call = this.systemB.apiCall("b-call");
    Message systemC_event = this.systemC.asyncEventOutgoing("c-event");
    Message systemC_call = this.systemC.apiCall("c-call");
    Message systemSink_call = this.systemSink.apiCall("sink-call");
    private static final Logger log = LoggerFactory.getLogger(UniverseTest.class);

    UniverseTest() {
    }

    @Test
    void testAAA() {
        this.systemA.feature("rule-under-test").rule(this.systemA_call, this.systemA_event, new Message[0]);
        this.systemSink.feature("sink").rule(this.systemA_event, this.systemSink_call, new Message[0]);
        Scenario scenario = this.universe.scenario("test").step(this.systemSource, this.systemA_call);
    }

    @Test
    void testBAA() {
        this.systemA.feature("rule-under-test").rule(this.systemB_event, this.systemA_event, new Message[0]);
        this.systemSink.feature("sink").rule(this.systemA_event, this.systemSink_call, new Message[0]);
        Scenario scenario = this.universe.scenario("test").step(this.systemSource, this.systemB_event);
    }

    @Test
    void testForeignSystem() {
        this.systemB.feature("foreignSystem").rule(this.systemB_call, "c1").action(this.systemB_event, "c2").build();
        this.systemSink.feature("sink").rule(this.systemB_event, "c3").action(this.systemSink_call, "c4").build();
        this.universe.validate();
        Scenario scenario = this.universe.scenario("test").step(this.systemA, this.systemB_call, "c0");
        List resultingSteps = this.universe.computeResultingSteps(scenario);
        this.dump("ForeignSystem", resultingSteps);
    }

    @Test
    void testBridge() {
        this.systemB.feature("bridge").rule(this.systemA_event, "c1").action(this.systemC_call, "c2").build();
        this.universe.validate();
        Scenario scenario = this.universe.scenario("test").step(this.systemA, this.systemA_event, " c3");
        List resultingSteps = this.universe.computeResultingSteps(scenario);
        this.dump("Bridge", resultingSteps);
    }

    private void dump(String s, List<ResultStep> resultingSteps) {
        StringBuilder b = new StringBuilder();
        b.append("== " + s + "\n");
        for (ResultStep rs : resultingSteps) {
            b.append(s + "   " + rs + "\n");
        }
        log.info("\n" + b.toString());
    }
}

