/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.wiki;

import de.xam.featdoc.I18n;
import de.xam.featdoc.Term;
import de.xam.featdoc.markdown.IMarkdownCustomizer;
import de.xam.featdoc.wiki.IWikiFile;
import de.xam.featdoc.wiki.IWikiLink;
import java.io.File;

public interface IWikiContext {
    public static final I18n i18n_de = new I18n(I18n.Language.de);

    public IMarkdownCustomizer markdownCustomizer();

    default public I18n i18n() {
        return i18n_de;
    }

    default public String i18n(Term term) {
        return this.i18n().resolve(term);
    }

    default public File markdownFile(IWikiFile wikiFile) {
        return new File(this.rootDir(), this.path(wikiFile) + ".md");
    }

    default public String path(IWikiFile wikiFile) {
        return (String)(this.rootPath() == null ? "" : this.rootPath() + "/") + wikiFile.wikiLink(this.i18n());
    }

    public File rootDir();

    default public String rootPath() {
        return "";
    }

    default public String wikiLink(IWikiLink wikiLink) {
        return "[" + wikiLink.label() + "](" + this.path(wikiLink) + ")";
    }
}

