/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import de.xam.featdoc.Util;
import de.xam.featdoc.markdown.MarkdownTool;
import de.xam.featdoc.markdown.StringTree;
import de.xam.featdoc.mermaid.sequence.Arrow;
import de.xam.featdoc.mermaid.sequence.SequenceDiagram;
import de.xam.featdoc.system.Condition;
import de.xam.featdoc.system.Feature;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Timing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Universe {
    private final List<Scenario> scenarios = new ArrayList<Scenario>();
    private final List<System> systems = new ArrayList<System>();
    private final List<Condition> conditions = new ArrayList<Condition>();

    public Condition condition(String label) {
        return Util.add(this.conditions, new Condition(label));
    }

    public Stream<Feature> featuresProducing(Message message) {
        return this.systems.stream().flatMap(system -> system.features().stream()).filter(feature -> feature.isProducing(message));
    }

    public void forEachEdge(BiConsumer<System, System> source_target) {
        this.scenarios().stream().flatMap(scenario -> scenario.steps().stream()).forEach(scenarioStep -> source_target.accept(scenarioStep.source(), scenarioStep.target()));
        this.systems().stream().flatMap(System::rules).forEach(rule -> rule.actions.forEach(target -> source_target.accept(rule.trigger.incomingMessage().system(), target.outgoingMessage().system())));
    }

    public Scenario scenario(String title) {
        return Util.add(this.scenarios, new Scenario(this, title));
    }

    public Stream<ScenarioStep> scenarioStepsProducing(Message message) {
        return this.scenarios.stream().flatMap(scenario -> scenario.steps().stream()).filter(scenarioStep -> scenarioStep.rulePart().message().equals(message));
    }

    public List<Scenario> scenarios() {
        return this.scenarios;
    }

    public System system(String id, String name, String wikiName) {
        return Util.add(this.systems, new System(id, name, wikiName, 0));
    }

    public System system(String id, String name, String wikiName, int sortOrder) {
        return Util.add(this.systems, new System(id, name, wikiName, sortOrder));
    }

    public List<System> systems() {
        return Collections.unmodifiableList(this.systems);
    }

    public Stream<System> systemsCalledFrom(System system) {
        TreeMultimap systemSystemMap = TreeMultimap.create();
        this.forEachEdge((arg_0, arg_1) -> ((SetMultimap)systemSystemMap).put(arg_0, arg_1));
        Set targets = systemSystemMap.get((Object)system);
        return targets.stream().sorted();
    }

    public Stream<System> systemsCalling(System system) {
        TreeMultimap systemSystemMap = TreeMultimap.create();
        this.forEachEdge((arg_0, arg_1) -> ((SetMultimap)systemSystemMap).put(arg_0, arg_1));
        return systemSystemMap.entries().stream().filter(e -> ((System)e.getValue()).equals(system)).map(Map.Entry::getKey).sorted();
    }

    public Stream<System> systemsProducing(Message message) {
        return this.systems.stream().filter(system -> system.isProducing(message));
    }

    public SequenceDiagram toSequence(Scenario scenario) {
        List<ResultStep> resultingSteps = this.computeResultingSteps(scenario);
        SequenceDiagram sequenceDiagram = new SequenceDiagram(scenario.label());
        resultingSteps.stream().flatMap(rs -> Stream.of(rs.source, rs.target)).distinct().sorted().forEach(system -> sequenceDiagram.participant(system.id, system.label));
        resultingSteps.forEach(step -> sequenceDiagram.step(step.source.id, step.rulePart.message().timing() == Timing.Synchronous ? Arrow.SolidWithHead : Arrow.DottedAsync, step.target.id, MarkdownTool.format(step.rulePart.message().name() + (String)(step.feature == null ? "" : " [" + step.feature.label + "]"))));
        return sequenceDiagram;
    }

    public List<StringTree> toTrees(Scenario scenario, Function<ResultStep, String> toMarkdown) {
        LinkedList<StringTree> stack = new LinkedList<StringTree>();
        StringTree root = new StringTree("ROOT Szenario: " + scenario.label());
        stack.add(root);
        List<ResultStep> resultingSteps = this.computeResultingSteps(scenario);
        int depth = 0;
        for (ResultStep rs : resultingSteps) {
            int delta = depth - rs.depth;
            if (delta > 0) {
                for (int i = 0; i < delta; ++i) {
                    stack.pop();
                    --depth;
                }
            }
            StringTree child = ((StringTree)stack.peek()).addChild(toMarkdown.apply(rs));
            stack.push(child);
            ++depth;
        }
        ArrayList<StringTree> trees = new ArrayList<StringTree>();
        root.getChildNodesIterator().forEachRemaining(trees::add);
        return trees;
    }

    public List<ResultStep> computeResultingSteps(Scenario scenario) {
        ArrayList<ResultStep> resultingSteps = new ArrayList<ResultStep>();
        for (ScenarioStep scenarioStep : scenario.steps()) {
            this.reactOnEventAndMaterializeActions(scenarioStep.rulePart(), scenarioStep.source(), scenarioStep.target(), scenarioStep, 0, resultingSteps::add);
        }
        return resultingSteps;
    }

    private void reactOnEventAndMaterializeActions(Rule.RulePart triggerRulePart, System source, @Nullable System target, ScenarioStep causeFromScenario, int depth, Consumer<ResultStep> resultConsumer) {
        if (target != null) {
            resultConsumer.accept(new ResultStep(null, null, triggerRulePart, depth, causeFromScenario, source, target));
        }
        for (System system : this.systems()) {
            for (Feature feature : system.features) {
                for (Rule rule : feature.rules) {
                    if (!rule.trigger.isTriggeredBy(triggerRulePart.message())) continue;
                    for (Rule.Action action : rule.actions) {
                        resultConsumer.accept(new ResultStep(feature, rule, action, depth + 1, causeFromScenario, triggerRulePart.message().system(), action.outgoingMessage().system()));
                        this.reactOnEventAndMaterializeActions(action, action.outgoingMessage().system(), null, causeFromScenario, depth + 1, resultConsumer);
                    }
                }
            }
        }
    }

    public record ResultStep(Feature feature, Rule rule, Rule.RulePart rulePart, int depth, ScenarioStep causeFromScenario, System source, System target) {
        public boolean isScenario() {
            return this.depth == 0;
        }
    }
}

