/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.I18n;
import de.xam.featdoc.Term;
import de.xam.featdoc.markdown.MarkdownTool;
import de.xam.featdoc.system.Condition;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Universe;
import de.xam.featdoc.wiki.IWikiLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Scenario
implements IWikiLink {
    private final String label;
    private final List<ScenarioStep> scenarioSteps = new ArrayList<ScenarioStep>();
    private final Universe universe;
    private Map<Condition, Condition.Variant> variants = new HashMap<Condition, Condition.Variant>();

    public Scenario(Universe universe, String label) {
        this.universe = universe;
        this.label = label;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String localTarget() {
        return MarkdownTool.filename(this.label());
    }

    public Scenario step(System source, System target, Message message, String comment) {
        if (message.system().equals(source)) {
            if (message.direction() != Message.Direction.OUTGOING) {
                throw new IllegalStateException("Message defined in source System " + source + " must be OUTGOING, is " + message);
            }
        } else if (message.system().equals(target)) {
            if (message.direction() != Message.Direction.INCOMING) {
                throw new IllegalStateException("Message defined in target System " + source + " must be INCOMING, is " + message);
            }
        } else {
            throw new IllegalStateException("Message not defined in either source (" + source.label + ") or target (" + target.label + ") system: " + message);
        }
        ScenarioStep scenarioStep = new ScenarioStep(this, source, target, new Rule.Trigger(message, comment));
        this.scenarioSteps.add(scenarioStep);
        return this;
    }

    public Scenario step(System source, System target, Message message) {
        return this.step(source, target, message, null);
    }

    public List<ScenarioStep> steps() {
        return Collections.unmodifiableList(this.scenarioSteps);
    }

    public Stream<System> systems() {
        return this.steps().stream().flatMap(scenarioStep -> Stream.of(scenarioStep.source(), scenarioStep.target())).distinct().sorted();
    }

    public Scenario variant(Condition.Variant variant) {
        Condition.Variant prev = this.variants.put(variant.condition(), variant);
        if (prev != null) {
            throw new IllegalStateException("condition '" + variant.condition().label() + "' already set to '" + prev.label() + "'");
        }
        return this;
    }

    @Override
    @Nullable
    public String wikiFolder(I18n i18n) {
        return i18n.resolve(Term.scenario);
    }
}

