/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.system.Feature;
import de.xam.featdoc.system.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Rule {
    final Feature feature;
    final List<Action> actions;
    final Trigger trigger;

    public Rule(Feature feature, Trigger trigger, List<Action> actions) {
        assert (feature != null);
        assert (trigger != null);
        assert (actions != null && !actions.isEmpty());
        this.feature = feature;
        this.trigger = trigger;
        this.actions = actions;
    }

    public static RuleBuilder builder(Feature feature) {
        return new InternalRuleBuilder().feature(feature);
    }

    public List<Action> actions() {
        return Collections.unmodifiableList(this.actions);
    }

    public Feature feature() {
        return this.feature;
    }

    public Stream<Message> producedEvents() {
        return this.actions.stream().map(Action::outgoingMessage);
    }

    public String toString() {
        return this.trigger + "=>{" + Arrays.asList(this.actions) + "}";
    }

    public Trigger trigger() {
        return this.trigger;
    }

    public record Trigger(Message incomingMessage, @Nullable String comment) implements RulePart
    {
        public Trigger(Message incomingMessage, @Nullable String comment) {
            if (incomingMessage == null) {
                throw new IllegalArgumentException();
            }
        }

        public boolean isTriggeredBy(Message message) {
            return this.message().name().equals(message.name()) && this.message().system().equals(message.system());
        }

        @Override
        public Message message() {
            return this.incomingMessage();
        }
    }

    private static class InternalRuleBuilder
    implements RuleBuilder,
    RuleWithTriggerBuilder {
        private final List<Action> actions = new ArrayList<Action>();
        private Feature feature;
        private Trigger trigger;

        private InternalRuleBuilder() {
        }

        @Override
        public RuleWithTriggerBuilder actions(Message ... actions) {
            for (Message message : actions) {
                this.action(message, null);
            }
            return this;
        }

        @Override
        public Feature build() {
            this.feature.rules.add(new Rule(this.feature, this.trigger, this.actions));
            return this.feature;
        }

        @Override
        public RuleBuilder feature(Feature feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public RuleWithTriggerBuilder trigger(Message triggerMessage) {
            return this.trigger(triggerMessage, null);
        }

        @Override
        public RuleWithTriggerBuilder trigger(Message triggerMessage, String triggerComment) {
            assert (triggerMessage != null);
            this.trigger = new Trigger(triggerMessage, triggerComment);
            return this;
        }

        @Override
        public RuleWithTriggerBuilder action(Message message, String comment) {
            this.actions.add(new Action(message, comment));
            return this;
        }
    }

    public static interface RuleBuilder {
        public RuleBuilder feature(Feature var1);

        public RuleWithTriggerBuilder trigger(Message var1, String var2);

        default public RuleWithTriggerBuilder trigger(Message triggerMessage) {
            return this.trigger(triggerMessage, null);
        }
    }

    public record Action(Message outgoingMessage, @Nullable String comment) implements RulePart
    {
        public Action(Message outgoingMessage, @Nullable String comment) {
            if (outgoingMessage == null) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Message message() {
            return this.outgoingMessage();
        }
    }

    public static interface RuleWithTriggerBuilder {
        public RuleWithTriggerBuilder action(Message var1, String var2);

        default public RuleWithTriggerBuilder action(Message action) {
            return this.action(action, null);
        }

        public RuleWithTriggerBuilder actions(Message ... var1);

        public Feature build();
    }

    public static interface RulePart {
        public String comment();

        public Message message();
    }
}

