/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.I18n;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.System;
import de.xam.featdoc.wiki.IWikiLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Feature
implements IWikiLink {
    final String label;
    final List<Rule> rules = new ArrayList<Rule>();
    private final System system;

    public Feature(System system, String label) {
        this.label = label;
        this.system = system;
    }

    public boolean isProducing(Message message) {
        return this.producedEvents().anyMatch(message::equals);
    }

    @Override
    public String label() {
        return this.label;
    }

    public Stream<Message> producedEvents() {
        return this.rules.stream().flatMap(Rule::producedEvents);
    }

    public Feature rule(Message trigger, Message ... actions) {
        if (actions == null || actions.length == 0) {
            throw new IllegalArgumentException("No actions given");
        }
        Rule.RuleWithTriggerBuilder builder = this.rule().feature(this).trigger(trigger, null);
        Stream.of(actions).forEach(action -> builder.action((Message)action, null));
        return builder.build();
    }

    public Rule.RuleWithTriggerBuilder rule(Message trigger, String comment) {
        return this.rule().trigger(trigger, comment);
    }

    public Rule.RuleBuilder rule() {
        return Rule.builder(this);
    }

    public List<Rule> rules() {
        return Collections.unmodifiableList(this.rules);
    }

    public System system() {
        return this.system;
    }

    public String toString() {
        return this.label;
    }

    @Override
    @Nullable
    public String wikiFolder(I18n i18n) {
        return this.system.wikiFolder(i18n);
    }
}

