/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.markdown;

import de.xam.featdoc.LineWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MarkdownTool {
    public static String escapePipes(String s) {
        return s.replace("|", "\\|");
    }

    public static String filename(String title) {
        String enc = URLEncoder.encode(title, StandardCharsets.UTF_8);
        enc = enc.replace("+", "-");
        enc = enc.replace("%2C", ",");
        enc = enc.replace("%28", "(");
        enc = enc.replace("%29", ")");
        return enc;
    }

    public static String format(String in) {
        return in.replace("|", "<br/>");
    }

    public static String fragmentId(String s) {
        String enc = s.toLowerCase();
        enc = enc.replace(" ", "-");
        enc = URLEncoder.encode(enc, StandardCharsets.UTF_8);
        enc = enc.replace("+", "%2B");
        enc = enc.replace("%28", "(");
        enc = enc.replace("%29", ")");
        return enc;
    }

    public static class Table {
        final LineWriter lineWriter;
        private int cols = -1;

        public Table(LineWriter lineWriter) {
            this.lineWriter = lineWriter;
        }

        public Table headerSeparator() {
            this.lineWriter.writeLine("|" + IntStream.range(0, this.cols).mapToObj(i -> "---").collect(Collectors.joining("|")) + "|", new String[0]);
            return this;
        }

        public Table row(String ... args) {
            if (this.cols > 0 && this.cols != args.length) {
                throw new IllegalArgumentException("Table rows must have some lenght");
            }
            this.lineWriter.writeLine("|" + Stream.of(args).map(MarkdownTool::escapePipes).collect(Collectors.joining("|")) + "|", new String[0]);
            this.cols = args.length;
            return this;
        }
    }
}

