/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import de.xam.featdoc.I18n;
import de.xam.featdoc.LineWriter;
import de.xam.featdoc.Term;
import de.xam.featdoc.markdown.IMarkdownCustomizer;
import de.xam.featdoc.markdown.MarkdownTool;
import de.xam.featdoc.markdown.MermaidBlockSyle;
import de.xam.featdoc.markdown.StringTree;
import de.xam.featdoc.mermaid.MermaidTool;
import de.xam.featdoc.mermaid.flowchart.FlowchartDiagram;
import de.xam.featdoc.mermaid.sequence.MermaidDiagram;
import de.xam.featdoc.mermaid.sequence.SequenceDiagram;
import de.xam.featdoc.system.Feature;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Universe;
import de.xam.featdoc.wiki.IWikiContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FeatDoc {
    static final String ARROW_RIGHT_LEFT_SOLID = "\u2b05";
    static final String ARROW_LEFT_RIGHT_SOLID = "\u2b95";
    static final String ARROW_RIGHT_LEFT_DASHED = "\u21e6";
    static final String ARROW_LEFT_RIGHT_DASHED = "\u21e8";
    static final String ARROW_LEFT_RIGHT_TINYWAVY = "\u27ff";
    static final String ARROW_LEFT_RIGHT_WAVY = "\u219d";
    static final String ARROW_LEFT_RIGHT_RULE = "\u21a6";

    private FeatDoc() {
    }

    private static void debugPage(Universe universe, IWikiContext wikiContext, LineWriter lineWriter) {
        lineWriter.writeToc();
        lineWriter.writeLine("# Debug Infos", new String[0]);
        lineWriter.writeLine("## Events, not used in any rules", new String[0]);
        Set<Message> allMessages = universe.systems().stream().flatMap(system -> system.events().stream()).collect(Collectors.toSet());
        HashSet usedInRules = new HashSet();
        universe.systems().stream().flatMap(System::rules).forEach(rule -> {
            usedInRules.add(rule.trigger().incomingMessage());
            usedInRules.addAll(rule.actions().stream().map(Rule.Action::outgoingMessage).collect(Collectors.toSet()));
        });
        allMessages.removeAll(usedInRules);
        allMessages.forEach(message -> lineWriter.writeLine("* %s ([%s](%s))", message.name(), message.system().label(), message.system().wikiLink(wikiContext.i18n())));
        lineWriter.writeLine("## Rules, not used in any scenario", new String[0]);
        Set<Rule> allRules = universe.systems().stream().flatMap(System::rules).collect(Collectors.toSet());
        Set usedInScenarios = universe.scenarios().stream().flatMap(scenario -> universe.computeResultingSteps((Scenario)scenario).stream()).map(Universe.ResultStep::rule).collect(Collectors.toSet());
        allRules.removeAll(usedInScenarios);
        allRules.forEach(rule -> lineWriter.writeLine("* Feature *%s* ([%s](%s)): No calls to trigger **%s**", rule.feature().label(), rule.feature().system().label(), rule.feature().system().wikiLink(wikiContext.i18n()), rule.trigger().incomingMessage().name()));
    }

    private static void eventsToMarkdown(Universe universe, System system, IWikiContext wikiContext, Predicate<Message> eventPredicate, LineWriter lineWriter) {
        system.events().stream().filter(eventPredicate).sorted(Comparator.comparing(Message::name)).forEach(event -> {
            lineWriter.writeLine("* **%s** [%s]%n", event.name(), FeatDoc.timing(event, wikiContext));
            universe.featuresProducing((Message)event).forEach(producingFeature -> lineWriter.writeLine("    * %s %s %s, %s %s/%s%n", ARROW_RIGHT_LEFT_SOLID, wikiContext.i18n(Term.callFrom), wikiContext.wikiLink(producingFeature.system()), wikiContext.i18n(Term.feature), wikiContext.wikiLink(producingFeature.system()), producingFeature.label()));
            universe.scenarioStepsProducing((Message)event).forEach(producingScenarioStep -> lineWriter.writeLine("    * %s %s %s, %s %s%n", ARROW_RIGHT_LEFT_SOLID, wikiContext.i18n(Term.callFrom), wikiContext.wikiLink(producingScenarioStep.source()), wikiContext.i18n(Term.scenario), wikiContext.wikiLink(producingScenarioStep.scenario())));
        });
    }

    private static String footer(I18n i18n) {
        String msg = String.format("\n%s\n", i18n.resolve(Term.footer));
        if (!msg.contains("%s")) {
            throw new IllegalArgumentException();
        }
        return String.format(msg, Instant.now());
    }

    public static void generateMarkdownFiles(Universe universe, IWikiContext wikiContext) throws IOException {
        MarkdownWriter markdownWriter = new MarkdownWriter(wikiContext);
        for (Scenario scenario : universe.scenarios()) {
            markdownWriter.write(wikiContext.markdownFile(scenario), lineWriter -> FeatDoc.scenarioPage(universe, scenario, wikiContext, lineWriter), FeatDoc.footer(wikiContext.i18n()));
        }
        for (System system : universe.systems()) {
            markdownWriter.write(wikiContext.markdownFile(system), lineWriter -> FeatDoc.systemPage(universe, system, wikiContext, lineWriter), FeatDoc.footer(wikiContext.i18n()));
        }
        markdownWriter.write(new File(wikiContext.rootDir(), (wikiContext.rootPath().isEmpty() ? "Index" : wikiContext.rootPath()) + ".md"), lineWriter -> FeatDoc.indexPage(universe, wikiContext, lineWriter), FeatDoc.footer(wikiContext.i18n()));
        markdownWriter.write(new File(wikiContext.rootDir(), wikiContext.rootPath() + "/DebugInfo.md"), lineWriter -> FeatDoc.debugPage(universe, wikiContext, lineWriter), FeatDoc.footer(wikiContext.i18n()));
    }

    private static void indexPage(Universe universe, IWikiContext wikiContext, LineWriter lineWriter) {
        lineWriter.writeToc();
        lineWriter.writeSection1(wikiContext.i18n(Term.scenarios), new String[0]);
        for (Scenario scenario : universe.scenarios()) {
            lineWriter.writeLine("* %s", wikiContext.wikiLink(scenario));
        }
        lineWriter.writeSection1(wikiContext.i18n(Term.systems), new String[0]);
        for (System system2 : universe.systems()) {
            lineWriter.writeLine("* %s", wikiContext.wikiLink(system2));
        }
        TreeMultimap multiMap = TreeMultimap.create();
        universe.forEachEdge((x$0, x$1) -> multiMap.put(x$0, x$1));
        FlowchartDiagram flowchartDiagram = FeatDoc.toMermaidFlowchart(wikiContext.i18n(Term.overviewCallsFromSystems), multiMap, system -> system.wikiName, System::label, false);
        FeatDoc.mermaidDiagramBlock(flowchartDiagram, wikiContext.markdownCustomizer(), lineWriter);
    }

    public static void mermaidDiagramBlock(MermaidDiagram mermaidDiagram, IMarkdownCustomizer markdownCustomizer, LineWriter lineWriter) {
        lineWriter.writeLine("", new String[0]);
        lineWriter.writeLine(switch (markdownCustomizer.mermaidBlockSyle()) {
            default -> throw new IncompatibleClassChangeError();
            case MermaidBlockSyle.Default -> "```mermaid";
            case MermaidBlockSyle.Microsoft -> ":::mermaid";
        }, new String[0]);
        MermaidTool.generateMermaidSyntax(mermaidDiagram, lineWriter);
        lineWriter.writeLine(switch (markdownCustomizer.mermaidBlockSyle()) {
            default -> throw new IncompatibleClassChangeError();
            case MermaidBlockSyle.Default -> "```";
            case MermaidBlockSyle.Microsoft -> ":::";
        }, new String[0]);
        lineWriter.writeLine("", new String[0]);
    }

    public static void scenarioPage(Universe universe, Scenario scenario, IWikiContext wikiContext, LineWriter lineWriter) {
        SequenceDiagram sequenceDiagram = universe.toSequence(scenario);
        lineWriter.writeSection1("%s: %s", wikiContext.i18n(Term.scenario), sequenceDiagram.title());
        lineWriter.writeToc();
        lineWriter.writeSection(wikiContext.i18n(Term.sequenceDiagram), new String[0]);
        FeatDoc.mermaidDiagramBlock(sequenceDiagram, wikiContext.markdownCustomizer(), lineWriter);
        lineWriter.writeSection(wikiContext.i18n(Term.scenarioSteps), new String[0]);
        FeatDoc.legend(wikiContext, lineWriter);
        List<Universe.ResultStep> resultingSteps = universe.computeResultingSteps(scenario);
        MarkdownTool.Table table = lineWriter.table().row("Nr", "From System", "   ", "To System", "Message", "Comment", "Rule Definition").headerSeparator();
        int rowNr = 1;
        for (Universe.ResultStep rs2 : resultingSteps) {
            table.row(new String[]{"" + rowNr++, wikiContext.wikiLink(rs2.source()), rs2.rulePart().message().isSynchronous() ? ARROW_LEFT_RIGHT_SOLID : ARROW_LEFT_RIGHT_DASHED, wikiContext.wikiLink(rs2.target()), rs2.rulePart().message().name(), rs2.rulePart().comment() == null ? "   " : "*" + rs2.rulePart().comment() + "*", rs2.isScenario() ? "**" + wikiContext.i18n(Term.scenario) + "**" : String.format("%s/%s", wikiContext.wikiLink(rs2.feature().system()), rs2.feature().label())});
        }
        lineWriter.writeSection(wikiContext.i18n(Term.scenarioTree), new String[0]);
        FeatDoc.legend(wikiContext, lineWriter);
        List<StringTree> trees = universe.toTrees(scenario, rs -> String.format("%s %s %s: **%s** (%s)", wikiContext.wikiLink(rs.source()), rs.rulePart().message().isAsynchronous() ? ARROW_LEFT_RIGHT_DASHED : ARROW_LEFT_RIGHT_SOLID, wikiContext.wikiLink(rs.target()), rs.rulePart().message().name(), rs.feature() == null ? wikiContext.i18n(Term.scenario) : wikiContext.wikiLink(rs.feature().system()) + "/" + rs.feature().label()));
        StringTree.toMarkdownList(trees, lineWriter);
    }

    private static void legend(IWikiContext wikiContext, LineWriter lineWriter) {
        lineWriter.write("**%s**: ", wikiContext.i18n(Term.legend));
        lineWriter.write("(%s) %s", ARROW_LEFT_RIGHT_SOLID, wikiContext.i18n(Term.synchronous));
        lineWriter.write(" | ", new String[0]);
        lineWriter.write("(%s) %s", ARROW_LEFT_RIGHT_DASHED, wikiContext.i18n(Term.asynchronous));
        lineWriter.writeLine("", new String[0]);
        lineWriter.writeLine("", new String[0]);
    }

    public static void systemPage(Universe universe, System system, IWikiContext wikiContext, LineWriter lineWriter) {
        lineWriter.writeLine("# %s: %s", wikiContext.i18n(Term.system), system.label());
        lineWriter.writeToc();
        lineWriter.writeLine("## %s", wikiContext.i18n(Term.features));
        for (Feature feature : system.features()) {
            lineWriter.writeLine("\n### %s: %s", wikiContext.i18n(Term.feature), feature.label(), feature.localTarget());
            for (Rule rule : feature.rules()) {
                lineWriter.writeLine("\n* %s: %s **%s** in %s [%s]", wikiContext.i18n(Term.rule), wikiContext.i18n(Term.if_), rule.trigger().incomingMessage().name(), rule.trigger().incomingMessage().system().label(), FeatDoc.timing(rule.trigger().incomingMessage(), wikiContext));
                for (Rule.Action action : rule.actions()) {
                    lineWriter.writeLine("    * %s %s **%s** in %s [%s]", ARROW_LEFT_RIGHT_RULE, wikiContext.i18n(Term.then_), action.outgoingMessage().name(), wikiContext.wikiLink(action.outgoingMessage().system()), FeatDoc.timing(action.outgoingMessage(), wikiContext));
                }
                if (rule.trigger().comment() == null) continue;
                lineWriter.writeLine("    * NOTE: *%s*", rule.trigger().comment());
            }
        }
        lineWriter.writeSection(wikiContext.i18n(Term.incomingApiCalls), new String[0]);
        FeatDoc.eventsToMarkdown(universe, system, wikiContext, Message::isSynchronous, lineWriter);
        lineWriter.writeSection(wikiContext.i18n(Term.incomingAsyncEvents), new String[0]);
        FeatDoc.eventsToMarkdown(universe, system, wikiContext, Message::isAsynchronous, lineWriter);
        lineWriter.writeSection(wikiContext.i18n(Term.systemLandscape), new String[0]);
        String[] stringArray = new String[2];
        stringArray[0] = wikiContext.i18n(Term.callsFrom);
        stringArray[1] = universe.systemsCalling(system).map(wikiContext::wikiLink).collect(Collectors.joining(", "));
        lineWriter.writeLine("* %s: %s", stringArray);
        String[] stringArray2 = new String[2];
        stringArray2[0] = wikiContext.i18n(Term.callsTo);
        stringArray2[1] = universe.systemsCalledFrom(system).map(wikiContext::wikiLink).collect(Collectors.joining(", "));
        lineWriter.writeLine("* %s: %s", stringArray2);
        TreeMultimap multiMap = TreeMultimap.create();
        universe.systemsCalling(system).forEach(source -> multiMap.put(source, (Object)system));
        universe.systemsCalledFrom(system).forEach(target -> multiMap.put((Object)system, target));
        FlowchartDiagram flowchartDiagram = FeatDoc.toMermaidFlowchart(wikiContext.i18n(Term.systemsOverview), multiMap, s -> s.wikiName, System::label, false);
        FeatDoc.mermaidDiagramBlock(flowchartDiagram, wikiContext.markdownCustomizer(), lineWriter);
    }

    private static String timing(Message message, IWikiContext wikiContext) {
        return message.isSynchronous() ? wikiContext.i18n(Term.synchronous) : wikiContext.i18n(Term.asynchronous);
    }

    public static <T> FlowchartDiagram toMermaidFlowchart(String title, Multimap<T, T> multimap, Function<T, String> idFun, Function<T, String> labelFun, boolean allowSelfLinks) {
        FlowchartDiagram flowchartDiagram = new FlowchartDiagram(title, FlowchartDiagram.Orientation.TD);
        multimap.keySet().forEach(node -> flowchartDiagram.node((String)idFun.apply(node), (String)labelFun.apply(node)));
        multimap.forEach((s, t) -> {
            if (allowSelfLinks || s != t) {
                flowchartDiagram.edge((String)idFun.apply(s), (String)idFun.apply(t));
            }
        });
        return flowchartDiagram;
    }

    record MarkdownWriter(IWikiContext wikiContext) {
        public void write(File f, Consumer<LineWriter> lineConsumerC, String footer) throws IOException {
            f.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(f);){
                LineWriter lineWriter = LineWriter.wrap(w);
                this.wikiContext.markdownCustomizer().preamble().ifPresent(x$0 -> lineWriter.write((String)x$0, new String[0]));
                lineConsumerC.accept(lineWriter);
                lineWriter.writeLine(footer, new String[0]);
                ((Writer)w).flush();
            }
        }
    }
}

