/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.I18n;
import de.xam.featdoc.Term;
import de.xam.featdoc.Util;
import de.xam.featdoc.system.Feature;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.SystemApi;
import de.xam.featdoc.system.Timing;
import de.xam.featdoc.wiki.IWikiLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class System
implements IWikiLink,
Comparable<System>,
SystemApi {
    public final String wikiName;
    final String id;
    final String label;
    final int sortOrder;
    final List<Feature> featureList = new ArrayList<Feature>();
    private final List<Message> messageList = new ArrayList<Message>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof System)) {
            return false;
        }
        System system = (System)o;
        return this.sortOrder == system.sortOrder && Objects.equals(this.label, system.label);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.sortOrder);
    }

    public int sortOrder() {
        return this.sortOrder;
    }

    public System(String mermaidDiagramId, String name, String wikiName, int sortOrder) {
        this.id = mermaidDiagramId;
        this.label = name;
        this.wikiName = wikiName;
        this.sortOrder = sortOrder;
    }

    @Override
    public Message step(Message.Direction direction, Timing timing, String name) {
        return Util.add(this.messageList, new Message(this, direction, timing, name));
    }

    @Override
    public int compareTo(@Nonnull System o) {
        return System.comparator().compare(this, o);
    }

    public static Comparator<System> comparator() {
        return Comparator.comparing(System::sortOrder).thenComparing(System::label);
    }

    public List<Message> events() {
        return Collections.unmodifiableList(this.messageList);
    }

    public Feature feature(String name) {
        Feature feature = new Feature(this, name);
        this.featureList.add(feature);
        return feature;
    }

    public List<Feature> features() {
        return Collections.unmodifiableList(this.featureList);
    }

    public boolean isProducing(Message message) {
        return this.producedEvents().filter(e -> e.equals(message)).findAny().isPresent();
    }

    @Override
    public String label() {
        return this.label;
    }

    public Stream<Rule> rules() {
        return this.features().stream().flatMap(f -> f.rules().stream());
    }

    @Override
    @Nullable
    public String wikiFolder(I18n i18n) {
        return i18n.resolve(Term.system);
    }

    public String toString() {
        return "[" + this.label + "]";
    }

    public Stream<Message> producedEvents() {
        return this.featureList.stream().flatMap(feature -> feature.producedEvents()).distinct();
    }

    @Override
    public String localTarget() {
        return this.wikiName;
    }
}

