/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.system.Cause;
import de.xam.featdoc.system.CauseAndEffect;
import de.xam.featdoc.system.Effect;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.System;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public record ResultStep(ScenarioStep scenarioStep, int depth, Cause cause, @Nullable Effect effect) {
    public ResultStep {
        if (effect != null && !cause.message().equals(effect.message())) {
            throw new IllegalArgumentException("Cause (" + cause.message() + ") and effect (" + effect.message() + ") don't match");
        }
    }

    public static ResultStep indirect(ScenarioStep scenarioStep, int depth, Cause cause, Effect effect) {
        return new ResultStep(scenarioStep, depth, cause, effect);
    }

    @Nullable
    public String effectComment() {
        return this.effect == null ? null : this.effect.comment();
    }

    @Nullable
    public System effectSystem() {
        return this.effect == null ? null : this.effect.system();
    }

    public boolean isScenario() {
        return this.depth == 0;
    }

    public Message message() {
        return this.cause.message();
    }

    public Stream<Rule> rules() {
        return Stream.of(this.cause, this.effect).filter(Objects::nonNull).map(CauseAndEffect::rule).distinct();
    }

    @Override
    public String toString() {
        return String.format("%-10s --> %-10s : Msg=%-40s | depth=%s | Feat=%s", this.cause.system().label, this.effect == null ? "--" : this.effect.system().label, this.cause.message().name() + (String)(this.effect == null ? "" : " // " + this.effect.message().name()), this.depth(), this.feature(this.cause) + "//" + this.feature(this.effect));
    }

    private String feature(CauseAndEffect causeAndEffect) {
        if (causeAndEffect == null) {
            return "--";
        }
        return "[" + causeAndEffect.system().label + "]." + causeAndEffect.message() + (causeAndEffect.comment() == null ? "no comment" : causeAndEffect.comment());
    }
}

