/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.mermaid.flowchart;

import de.xam.featdoc.LineWriter;
import de.xam.featdoc.Util;
import de.xam.featdoc.mermaid.flowchart.Edge;
import de.xam.featdoc.mermaid.flowchart.INode;
import de.xam.featdoc.mermaid.flowchart.Node;
import de.xam.featdoc.mermaid.sequence.MermaidDiagram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FlowchartDiagram
implements MermaidDiagram {
    private static final String INDENT = "    ";
    private final String title;
    private final Orientation orientation;
    private Map<String, INode> nodeMap = new HashMap<String, INode>();
    private List<Edge> edges = new ArrayList<Edge>();

    public FlowchartDiagram(String title, Orientation orientation) {
        this.title = title;
        this.orientation = orientation;
    }

    public FlowchartDiagram edge(Node source, Node target) {
        return this.edge(source.id(), target.id());
    }

    public FlowchartDiagram edge(String sourceId, String targetId) {
        Util.add(this.edges, new Edge(sourceId, Edge.Arrow.standard(), null, targetId));
        return this;
    }

    public List<Edge> edges() {
        return this.edges;
    }

    public Node node(String id) {
        return this.node(id, null);
    }

    public Node node(String id, String label) {
        Node node = new Node(id, Node.Shape.Box, label);
        this.nodeMap.put(id, node);
        return node;
    }

    public Map<String, INode> nodeMap() {
        return this.nodeMap;
    }

    public Orientation orientation() {
        return this.orientation;
    }

    public Subgraph subgraph(String id) {
        Subgraph subgraph = new Subgraph(id);
        this.nodeMap.put(id, subgraph);
        return subgraph;
    }

    public String title() {
        return this.title;
    }

    public static enum Orientation {
        TD,
        TB,
        RL,
        LR,
        BT;

    }

    public class Subgraph
    implements INode {
        private final String id;
        private List<Edge> edges = new ArrayList<Edge>();

        public Subgraph(String id) {
            this.id = id;
        }

        public Subgraph edge(Node source, Node target) {
            this.edges.add(new Edge(source.id(), Edge.Arrow.standard(), null, target.id()));
            return this;
        }

        public FlowchartDiagram end() {
            return FlowchartDiagram.this;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<String> text() {
            return Optional.empty();
        }

        @Override
        public void toMermaidSyntax(LineWriter lineWriter) {
            lineWriter.writeLine("subgraph %s", this.id);
            for (Edge edge : this.edges) {
                lineWriter.writeLine("%s%s", FlowchartDiagram.INDENT, edge.toMermaidSyntax());
            }
            lineWriter.writeLine("end", new String[0]);
        }
    }
}

