/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.markdown;

import com.google.common.collect.ListMultimap;
import de.xam.featdoc.LineWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StringTree
implements Comparable<StringTree> {
    private static final String INDENT = "    ";
    private final @NonNull String label;
    private final List<StringTree> children = new ArrayList<StringTree>();

    public StringTree(@NonNull String label) {
        this.label = label;
    }

    public static StringTree toTree(ListMultimap<String, String> pairs) {
        HashMap map = new HashMap();
        HashSet roots = new HashSet();
        roots.addAll(pairs.keySet());
        pairs.forEach((s, t) -> {
            roots.remove(t);
            StringTree sTree = map.computeIfAbsent(s, k -> new StringTree((String)s));
            map.compute(t, (k, v) -> {
                if (v == null) {
                    return sTree.addChild((String)t);
                }
                sTree.addChildTree((StringTree)v);
                return v;
            });
        });
        if (roots.isEmpty()) {
            return new StringTree("-EMPTY-");
        }
        if (roots.size() == 1) {
            return (StringTree)map.get(roots.iterator().next());
        }
        StringTree result = new StringTree("-TREE-");
        for (String root : roots) {
            StringTree tree = (StringTree)map.get(root);
            result.addChildTree(tree);
        }
        return result;
    }

    public StringTree addChild(@NonNull String label) {
        StringTree child = new StringTree(label);
        return this.addChildTree(child);
    }

    public StringTree addChildTree(StringTree child) {
        this.children.add(child);
        return child;
    }

    @Override
    public int compareTo(StringTree o) {
        return this.getLabel().compareTo(o.getLabel());
    }

    public void dump() {
        this.dump("");
    }

    public Iterator<StringTree> getChildNodesIterator() {
        return this.children.iterator();
    }

    public Iterator<StringTree> getChildNodesIterator(StringTree node) {
        return node.getChildNodesIterator();
    }

    public String getLabel() {
        return this.label;
    }

    public StringTree getOrCreateChild(@NonNull String s) {
        for (StringTree child : this.children) {
            if (!child.getLabel().equals(s)) continue;
            return child;
        }
        return this.addChild(s);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void sort() {
        Collections.sort(this.children);
        this.children.forEach(c -> c.sort());
    }

    public void toMarkdownList(LineWriter lineWriter) {
        this.toMarkdownList(0, "*", lineWriter);
    }

    public static void toMarkdownList(List<StringTree> trees, LineWriter lineWriter) {
        for (StringTree tree : trees) {
            tree.toMarkdownList(0, "*", lineWriter);
        }
    }

    public String toString() {
        return this.label + "(" + this.children.size() + ")";
    }

    private void dump(String indent) {
        System.out.println(indent + this.label);
        for (StringTree child : this.children) {
            child.dump(indent + "@---");
        }
    }

    private boolean isJustAChain() {
        switch (this.children.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.children.get(0).isJustAChain();
            }
        }
        return false;
    }

    private void toMarkdownList(int depth, String marker, LineWriter lineWriter) {
        Object pre = "";
        for (int i = 0; i < depth; ++i) {
            pre = (String)pre + INDENT;
        }
        lineWriter.writeLine("%s%s %s", new String[]{pre, marker, this.label});
        this.children.forEach(child -> child.toMarkdownList(depth + 1, marker, lineWriter));
    }
}

