/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc;

import de.xam.featdoc.markdown.StringTree;
import de.xam.featdoc.system.Cause;
import de.xam.featdoc.system.CauseAndEffect;
import de.xam.featdoc.system.Effect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CausalTree {
    private final CauseAndEffect causeAndEffect;
    private final List<CausalTree> children = new ArrayList<CausalTree>();

    private CausalTree(CauseAndEffect causeAndEffect) {
        this.causeAndEffect = causeAndEffect;
    }

    public static CausalTree create(Cause cause) {
        return new CausalTree(cause);
    }

    private static void dump(CausalTree causalTree, StringTree stringTree) {
        causalTree.getChildNodesIterator().forEachRemaining(causalChild -> {
            StringTree stringChild = stringTree.addChild(causalChild.getCauseAndEffect().system() + " {" + causalChild.getCauseAndEffect().message().system() + "." + causalChild.getCauseAndEffect().message().name() + "-" + causalChild.getCauseAndEffect().message().direction() + "}");
            CausalTree.dump(causalChild, stringChild);
        });
    }

    public CausalTree addCause(@NonNull Cause cause) {
        CausalTree child = new CausalTree(cause);
        return this.addChildTree(child);
    }

    public CausalTree addEffect(@NonNull Effect effect) {
        CausalTree child = new CausalTree(effect);
        return this.addChildTree(child);
    }

    public void dump() {
        StringTree stringTree = new StringTree("CausalTree on " + this.causeAndEffect);
        CausalTree.dump(this, stringTree);
        stringTree.dump();
    }

    public CauseAndEffect getCauseAndEffect() {
        return this.causeAndEffect;
    }

    public Iterator<CausalTree> getChildNodesIterator() {
        return this.children.iterator();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String toString() {
        return this.causeAndEffect + "(" + this.children.size() + ")";
    }

    private CausalTree addChildTree(CausalTree child) {
        this.children.add(child);
        return child;
    }

    private boolean isJustAChain() {
        switch (this.children.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.children.get(0).isJustAChain();
            }
        }
        return false;
    }
}

