/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import com.google.common.truth.Truth;
import de.xam.featdoc.CausalTree;
import de.xam.featdoc.example.RestaurantSystemsAndScenarios;
import de.xam.featdoc.system.Example1;
import de.xam.featdoc.system.Example2;
import de.xam.featdoc.system.GenerateExampleDocumentation;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.ResultStep;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.Universe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UniverseTest {
    private static final Logger log = LoggerFactory.getLogger(UniverseTest.class);

    UniverseTest() {
    }

    @BeforeAll
    static void beforeAll() {
        Example2.initOnce();
        Example2.scenario1.label();
    }

    @Test
    void causalTree() {
        Scenario scenario = Example2.scenario1;
        List trees = Universe.toCausalTrees((Scenario)scenario);
        trees.forEach(CausalTree::dump);
    }

    @Test
    void causalTreeCoffee() {
        RestaurantSystemsAndScenarios.define();
        Scenario scenario = (Scenario)RestaurantSystemsAndScenarios.Systems.UNIVERSE.scenariosList().get(0);
        List trees = Universe.toCausalTrees((Scenario)scenario);
        trees.forEach(CausalTree::dump);
    }

    @Test
    void generateExample() throws IOException {
        GenerateExampleDocumentation.generateFiles(Example2.universe, "FeatDocExample");
    }

    @Test
    void resultingAction() {
        ArrayList<Rule.Action> actionList = new ArrayList<Rule.Action>();
        Example2.universe.forEachResultingAction(((ScenarioStep)Example2.scenario1.steps().get(0)).message(), (rule, action) -> actionList.add((Rule.Action)action), true);
        log.info("Res:\n" + actionList.stream().map(action -> action.message().name()).collect(Collectors.joining("\n,")));
        this.assertActions(actionList, "bCall1", "cCall", "bCall2", "aEventOut", "cCall", "dEventOut", "eEventOut");
    }

    @Test
    void testAAA() {
        Example1.systemA.feature("rule-under-test").rule(Example1.systemA_call, Example1.systemA_event, new Message[0]);
        Example1.systemSink.feature("sink").rule(Example1.systemA_event, Example1.systemSink_call, new Message[0]);
        Scenario scenario = Example1.universe.scenario("test").step(Example1.systemSource, Example1.systemA_call);
    }

    @Test
    void testBAA() {
        Example1.systemA.feature("rule-under-test").rule(Example1.systemB_event, Example1.systemA_event, new Message[0]);
        Example1.systemSink.feature("sink").rule(Example1.systemA_event, Example1.systemSink_call, new Message[0]);
        Scenario scenario = Example1.universe.scenario("test").step(Example1.systemSource, Example1.systemB_event);
    }

    @Test
    void testBridge() {
        Example1.systemB.feature("bridge").rule(Example1.systemA_event, "c1").action(Example1.systemC_call, "c2").build();
        Example1.universe.validate();
        Scenario scenario = Example1.universe.scenario("test").step(Example1.systemA, Example1.systemA_event, " c3");
        List resultingSteps = Example1.universe.computeResultingSteps(scenario);
        this.dump("Bridge", resultingSteps);
    }

    @Test
    void testForeignSystem() {
        Scenario scenario = Example1.createForeignSystemScenario();
        List resultingSteps = Example1.universe.computeResultingSteps(scenario);
        this.dump("ForeignSystem", resultingSteps);
    }

    private void assertActions(List<Rule.Action> actual, String ... expected) {
        List actualList = actual.stream().map(action -> action.message().name()).collect(Collectors.toList());
        List<String> expectedList = Arrays.asList(expected);
        Assertions.assertIterableEquals(expectedList, actualList, (String)(" Actual: " + actualList));
    }

    private void dump(String s, List<ResultStep> resultingSteps) {
        StringBuilder b = new StringBuilder();
        b.append("== " + s + "\n");
        for (ResultStep rs : resultingSteps) {
            b.append(s + "   " + rs + "\n");
        }
        log.info("\n" + b.toString());
    }

    @Test
    void testSystemCallingCalled() {
        Example2.initOnce();
        log.info("a calls " + Example2.universe.systemsCalling(Example2.a).toList());
        log.info("c calls " + Example2.universe.systemsCalling(Example2.c).toList());
        log.info("d calls " + Example2.universe.systemsCalling(Example2.d).toList());
        log.info("a called from " + Example2.universe.systemsCalledFrom(Example2.a).toList());
        log.info("c called from " + Example2.universe.systemsCalledFrom(Example2.c).toList());
        log.info("d called from " + Example2.universe.systemsCalledFrom(Example2.d).toList());
        log.info("source calls " + Example2.universe.systemsCalling(Example2.source).toList());
        log.info("source called from " + Example2.universe.systemsCalledFrom(Example2.source).toList());
        log.info("source called from " + Example2.universe.systemsCalledFrom(Example2.source).toList());
        log.info("source called from " + Example2.universe.systemsCalledFrom(Example2.source).toList());
        Truth.assertThat(Example2.universe.systemsCalledFrom(Example2.source).toList()).containsExactlyElementsIn(List.of(Example2.a, Example2.f));
        Truth.assertThat(Example2.universe.systemsCalledFrom(Example2.a).toList()).containsExactlyElementsIn(List.of(Example2.a, Example2.b, Example2.d, Example2.e));
        Truth.assertThat(Example2.universe.systemsCalledFrom(Example2.b).toList()).containsExactlyElementsIn(List.of(Example2.c));
        Truth.assertThat(Example2.universe.systemsCalledFrom(Example2.c).toList()).containsExactlyElementsIn(List.of());
        Truth.assertThat(Example2.universe.systemsCalledFrom(Example2.d).toList()).containsExactlyElementsIn(List.of(Example2.c, Example2.d));
        Truth.assertThat(Example2.universe.systemsCalledFrom(Example2.e).toList()).containsExactlyElementsIn(List.of(Example2.e));
    }
}

