/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Universe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Example2 {
    private static final Logger log = LoggerFactory.getLogger(Example2.class);
    public static final Universe universe = new Universe();
    public static final System source = universe.system("source", "source", "source");
    public static final System a = universe.system("a", "a", "a");
    public static final System b = universe.system("b", "b", "b");
    public static final System c = universe.system("c", "c", "c");
    public static final System d = universe.system("d", "d", "d");
    public static final System e = universe.system("e", "e", "e");
    public static final System f = universe.system("f", "f", "f");
    public static final Message aCall = a.apiCall("aCall");
    public static final Message aEventOut = a.asyncEventOutgoing("aEventOut");
    public static final Message bCall1 = b.apiCall("bCall1");
    public static final Message bCall2 = b.apiCall("bCall2");
    public static final Message cCall = c.apiCall("cCall");
    public static final Message dEventOut = d.asyncEventOutgoing("dEventOut");
    public static final Message eEventOut = e.asyncEventOutgoing("eEventOut");
    public static final Message fCall = f.apiCall("fCall");
    public static Scenario scenario1;
    private static boolean initialized;

    static void defineScenarios() {
        scenario1 = universe.scenario("Scenario-1").step(source, aCall, "source-to-a-Comment").step(source, fCall, "source-calls-f-nothing-happens");
        log.info("ExampleUniverse scenarios defined.");
    }

    static void defineSystems() {
        a.feature("af").rule(aCall, "aCallComment").action(bCall1, "af-bCall1Comment").action(bCall2, "af-bCall2Comment").build().rule(aCall, "aCall2Comment").action(aEventOut, "a-sendEvent").build();
        b.feature("bf").rule(bCall1, "bCall1Comment").action(cCall, "b-call-c").build();
        d.feature("df").rule(aEventOut, "d-send-aOut").action(cCall, "d-call-c").action(dEventOut, "d-event").build();
        e.feature("ef").rule(aEventOut, "e-send-aOut").action(eEventOut, "e-event").build();
        log.info("ExampleUniverse systems defined.");
    }

    static synchronized void initOnce() {
        if (!initialized) {
            Example2.defineSystems();
            Example2.defineScenarios();
            initialized = true;
        }
    }

    static {
        initialized = false;
    }
}

