/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import com.google.common.base.Joiner;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import de.xam.featdoc.CausalTree;
import de.xam.featdoc.Util;
import de.xam.featdoc.markdown.StringTree;
import de.xam.featdoc.mermaid.sequence.Arrow;
import de.xam.featdoc.mermaid.sequence.SequenceDiagram;
import de.xam.featdoc.system.Cause;
import de.xam.featdoc.system.Condition;
import de.xam.featdoc.system.Effect;
import de.xam.featdoc.system.Feature;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.ResultStep;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.RuleCause;
import de.xam.featdoc.system.RuleEffect;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.TerminalEffect;
import de.xam.featdoc.system.Timing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Universe {
    private final List<Scenario> scenarios = new ArrayList<Scenario>();
    private final List<System> systems = new ArrayList<System>();
    private final List<Condition> conditions = new ArrayList<Condition>();

    public static String commentInMermaidLineLabel(@Nullable String comment) {
        return comment == null ? null : "(" + comment + ")";
    }

    public static String join(String joiner, String ... parts) {
        return Joiner.on((String)joiner).skipNulls().join((Object[])parts);
    }

    public static CausalTree toCausalTree(ScenarioStep scenarioStep) {
        CausalTree causalTree = CausalTree.create(scenarioStep);
        scenarioStep.scenario().universe().toCausalTree(scenarioStep, causalTree);
        return causalTree;
    }

    public static List<CausalTree> toCausalTrees(Scenario scenario) {
        return scenario.steps().stream().map(Universe::toCausalTree).collect(Collectors.toList());
    }

    public List<ResultStep> computeResultingSteps(Scenario scenario) {
        ArrayList<ResultStep> resultingSteps = new ArrayList<ResultStep>();
        for (ScenarioStep step : scenario.steps()) {
            Chain chain = new Chain(step, resultingSteps::add);
            chain.react();
        }
        return resultingSteps;
    }

    public Stream<Feature> features() {
        return this.systems().stream().flatMap(system -> system.featureList.stream());
    }

    public Stream<Feature> featuresProducing(Message message) {
        return this.systems.stream().flatMap(system -> system.features().stream()).filter(feature -> feature.isProducing(message));
    }

    public void forEachEdge(BiConsumer<System, System> source_target) {
        this.scenarios().stream().flatMap(scenario -> scenario.steps().stream()).forEach(scenarioStep -> source_target.accept(scenarioStep.sourceSystem(), scenarioStep.message().system()));
        this.systems().stream().flatMap(System::rules).forEach(rule -> rule.actions().forEach(target -> source_target.accept(rule.trigger().message().system(), target.message().system())));
    }

    public void forEachResultingAction(Message message, BiConsumer<Rule, Rule.Action> rule_action, boolean transitive) {
        this.rules().filter(rule -> rule.trigger().isTriggeredBy(message)).forEach(rule -> rule.actions().forEach(action -> {
            rule_action.accept((Rule)rule, (Rule.Action)action);
            if (transitive) {
                this.forEachResultingAction(action.message(), rule_action, transitive);
            }
        }));
    }

    public Scenario scenario(String title) {
        return Util.add(this.scenarios, new Scenario(this, title));
    }

    public Stream<ScenarioStep> scenarioStepsProducing(Message message) {
        return this.scenarios.stream().flatMap(scenario -> scenario.steps().stream()).filter(scenarioStep -> scenarioStep.message().equals(message));
    }

    public List<Scenario> scenarios() {
        return this.scenarios;
    }

    public System system(String id, String name, String wikiName) {
        return Util.add(this.systems, new System(id, name, wikiName, 0));
    }

    public System system(String id, String name, String wikiName, int sortOrder) {
        return Util.add(this.systems, new System(id, name, wikiName, sortOrder));
    }

    public List<System> systems() {
        return Collections.unmodifiableList(this.systems);
    }

    public Stream<System> systemsCalledFrom(System system) {
        TreeMultimap systemSystemMap = TreeMultimap.create();
        this.forEachEdge((arg_0, arg_1) -> ((SetMultimap)systemSystemMap).put(arg_0, arg_1));
        Set targets = systemSystemMap.get((Object)system);
        return targets.stream().sorted();
    }

    public Stream<System> systemsCalling(System system) {
        TreeMultimap systemSystemMap = TreeMultimap.create();
        this.forEachEdge((arg_0, arg_1) -> ((SetMultimap)systemSystemMap).put(arg_0, arg_1));
        return systemSystemMap.entries().stream().filter(e -> ((System)e.getValue()).equals(system)).map(Map.Entry::getKey).sorted();
    }

    public Stream<System> systemsProducing(Message message) {
        return this.systems.stream().filter(system -> system.isProducing(message));
    }

    public SequenceDiagram toSequence(Scenario scenario) {
        List<ResultStep> resultingSteps = this.computeResultingSteps(scenario);
        SequenceDiagram sequenceDiagram = new SequenceDiagram(scenario.label());
        resultingSteps.stream().flatMap(rs -> Stream.of(rs.cause().system(), rs.effectSystem())).filter(Objects::nonNull).distinct().sorted().forEach(system -> sequenceDiagram.participant(system.id, system.label));
        resultingSteps.forEach(step -> sequenceDiagram.step(step.cause().system().id, step.message().timing() == Timing.Synchronous ? Arrow.SolidWithHead : Arrow.DottedAsync, (step.effect() == null ? step.message().system() : step.effect().system()).id, this.combinedMessageOnSeqenceDiagram(step.cause(), step.effect())));
        return sequenceDiagram;
    }

    public List<StringTree> toTrees(Scenario scenario, Function<ResultStep, String> toMarkdown) {
        LinkedList<StringTree> stack = new LinkedList<StringTree>();
        StringTree root = new StringTree("ROOT Scenario: " + scenario.label());
        stack.add(root);
        List<ResultStep> resultingSteps = this.computeResultingSteps(scenario);
        int depth = 0;
        for (ResultStep rs : resultingSteps) {
            int delta = depth - rs.depth();
            if (delta > 0) {
                for (int i = 0; i < delta; ++i) {
                    stack.pop();
                    --depth;
                }
            }
            StringTree child = ((StringTree)stack.peek()).addChild(toMarkdown.apply(rs));
            stack.push(child);
            ++depth;
        }
        ArrayList<StringTree> trees = new ArrayList<StringTree>();
        root.getChildNodesIterator().forEachRemaining(trees::add);
        return trees;
    }

    public void validate() {
        this.features().forEach(feature -> {
            if (feature.hasUnfinishedRules()) {
                throw new IllegalStateException(String.format("System '%s' in feature '%s' has an unfinished rule. Likely you forgot to call 'build()'.", feature.system().label, feature.label));
            }
        });
    }

    private String combinedMessageOnSeqenceDiagram(Cause cause, @Nullable Effect effect) {
        String[] lines = effect == null ? new String[]{Universe.commentInMermaidLineLabel(cause.comment()), cause.message().name()} : new String[]{Universe.commentInMermaidLineLabel(cause.comment()), cause.message().name(), Universe.commentInMermaidLineLabel(effect.comment())};
        return Universe.join("<br/>", lines);
    }

    private Stream<Rule> rules() {
        return this.systems().stream().flatMap(System::rules);
    }

    private void toCausalTree(Cause cause, CausalTree causalTree) {
        this.forEachResultingAction(cause.message(), (rule, action) -> {
            CausalTree causalChild = causalTree.addEffect(new RuleEffect((Rule)rule, (Rule.RulePart)action));
            this.toCausalTree(new RuleCause((Rule)rule, (Rule.RulePart)action), causalChild);
        }, false);
    }

    class Chain {
        private final ScenarioStep scenarioStep;
        private final Consumer<ResultStep> resultConsumer;

        public Chain(ScenarioStep scenarioStep, Consumer<ResultStep> resultConsumer) {
            this.scenarioStep = scenarioStep;
            this.resultConsumer = resultConsumer;
        }

        public void react() {
            this.reactOn(0, this.scenarioStep);
        }

        private void chain(int depth, Cause cause, Effect effect) {
            this.resultConsumer.accept(ResultStep.indirect(this.scenarioStep, depth, cause, effect));
        }

        private void reactOn(int depth, Cause cause) {
            AtomicBoolean isAnyRuleTriggered = new AtomicBoolean(false);
            Universe.this.rules().forEach(rule -> {
                if (rule.trigger().isTriggeredBy(cause.message())) {
                    isAnyRuleTriggered.set(true);
                    this.chain(depth, cause, new RuleEffect((Rule)rule, rule.trigger()));
                    for (Rule.Action action : rule.actions()) {
                        RuleEffect ruleEffect = new RuleEffect((Rule)rule, action);
                        this.reactOn(depth + 1, ruleEffect);
                    }
                }
            });
            if (!isAnyRuleTriggered.get()) {
                switch (cause.message().direction()) {
                    case OUTGOING: {
                        this.chain(depth, cause, null);
                        break;
                    }
                    case INCOMING: {
                        this.chain(depth, cause, TerminalEffect.of(cause));
                    }
                }
            }
        }
    }
}

