/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.I18n;
import de.xam.featdoc.Term;
import de.xam.featdoc.markdown.MarkdownTool;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Universe;
import de.xam.featdoc.wiki.IWikiLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scenario
implements IWikiLink {
    private final String label;
    private final List<ScenarioStep> scenarioSteps = new ArrayList<ScenarioStep>();
    private final Universe universe;
    private static final Logger log = LoggerFactory.getLogger(Scenario.class);

    public String toString() {
        return "Scenario{'" + this.label + "' " + this.scenarioSteps.size() + "}";
    }

    public Scenario(Universe universe, String label) {
        this.universe = universe;
        this.label = label;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String localTarget() {
        return MarkdownTool.filename(this.label());
    }

    public Scenario step(System sourceSystem, Message message, String comment) {
        if (message.isOutgoing() && !message.system().equals(sourceSystem)) {
            log.warn("Calling an outgoing message ({}) from another system ({}) doesn't make sense.", (Object)message, (Object)sourceSystem);
        }
        ScenarioStep scenarioStep = new ScenarioStep(this, sourceSystem, message, comment);
        this.scenarioSteps.add(scenarioStep);
        return this;
    }

    public Scenario step(System source, Message message) {
        return this.step(source, message, null);
    }

    public List<ScenarioStep> steps() {
        return Collections.unmodifiableList(this.scenarioSteps);
    }

    public Universe universe() {
        return this.universe;
    }

    @Override
    @Nullable
    public String wikiFolder(I18n i18n) {
        return i18n.resolve(Term.scenario);
    }
}

