/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.system.Feature;
import de.xam.featdoc.system.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Rule {
    private final Feature feature;
    private final List<Action> actions;
    private final Trigger trigger;

    public Rule(Feature feature, Trigger trigger, @Nullable List<Action> actions) {
        if (trigger == null) {
            throw new IllegalArgumentException("null-trigger");
        }
        if (trigger.message().isIncoming() && !trigger.message().system().equals(feature.system())) {
            throw new IllegalArgumentException(String.format("Cannot consume an incoming message '%s' (defined in system '%s') in rule of system '%s' -- see feature '%s'", trigger.message.name(), trigger.message.system().label, feature.system().label, feature.label));
        }
        this.actions = actions == null ? new ArrayList() : actions;
        for (Action action : actions) {
            if (!action.message().isOutgoing() || action.message().system().equals(feature.system())) continue;
            throw new IllegalArgumentException(String.format("Cannot produce an outgoing message '%s' (defined in system '%s') in rule of system '%s' -- see feature '%s'", action.message().name(), action.message().system().label, feature.system().label, feature.label));
        }
        this.feature = feature;
        this.trigger = trigger;
    }

    public static RuleBuilder builder(Feature feature) {
        return new InternalRuleBuilder().feature(feature);
    }

    public List<Action> actions() {
        return Collections.unmodifiableList(this.actions);
    }

    public Feature feature() {
        return this.feature;
    }

    public Stream<Message> producedEvents() {
        return this.actions.stream().map(Action::message);
    }

    public String toString() {
        return this.trigger + "=>{" + Arrays.asList(this.actions) + "}";
    }

    public Trigger trigger() {
        return this.trigger;
    }

    public record Trigger(Message message, @Nullable String comment) implements RulePart
    {
        public Trigger {
            if (message == null) {
                throw new IllegalArgumentException();
            }
        }

        public boolean isTriggeredBy(Message message) {
            return this.message().name().equals(message.name()) && this.message().system().equals(message.system());
        }
    }

    public record Action(Message message, @Nullable String comment) implements RulePart
    {
        public Action {
            if (message == null) {
                throw new IllegalArgumentException();
            }
        }
    }

    static class InternalRuleBuilder
    implements RuleBuilder,
    RuleWithTriggerBuilder {
        private final List<Action> actions = new ArrayList<Action>();
        private Feature feature;
        private Trigger trigger;

        InternalRuleBuilder() {
        }

        @Override
        public RuleWithTriggerBuilder action(Message message, String comment) {
            this.actions.add(new Action(message, comment));
            return this;
        }

        @Override
        public RuleWithTriggerBuilder actions(Message ... actions) {
            for (Message message : actions) {
                this.action(message, null);
            }
            return this;
        }

        @Override
        public Feature build() {
            this.feature.rules.add(new Rule(this.feature, this.trigger, this.actions));
            this.feature.rulesUnderConstruction.remove(this);
            return this.feature;
        }

        @Override
        public RuleBuilder feature(Feature feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public RuleWithTriggerBuilder trigger(Message triggerMessage, String triggerComment) {
            if (triggerMessage == null) {
                throw new IllegalArgumentException("Trigger is null");
            }
            this.trigger = new Trigger(triggerMessage, triggerComment);
            this.feature.rulesUnderConstruction.add(this);
            return this;
        }

        @Override
        public RuleWithTriggerBuilder trigger(Message triggerMessage) {
            return this.trigger(triggerMessage, null);
        }
    }

    public static interface RuleBuilder {
        public RuleBuilder feature(Feature var1);

        public RuleWithTriggerBuilder trigger(Message var1, String var2);

        default public RuleWithTriggerBuilder trigger(Message triggerMessage) {
            return this.trigger(triggerMessage, null);
        }
    }

    public static interface RuleWithTriggerBuilder {
        public RuleWithTriggerBuilder action(Message var1, String var2);

        default public RuleWithTriggerBuilder action(Message action) {
            return this.action(action, null);
        }

        public RuleWithTriggerBuilder actions(Message ... var1);

        public Feature build();
    }

    public static interface RulePart {
        public String comment();

        public Message message();
    }
}

