/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.I18n;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.System;
import de.xam.featdoc.wiki.IWikiLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Feature
implements IWikiLink {
    final String label;
    final List<Rule> rules = new ArrayList<Rule>();
    private final System system;
    public List<Rule.InternalRuleBuilder> rulesUnderConstruction = new ArrayList<Rule.InternalRuleBuilder>();

    public Feature(System system, String label) {
        this.label = label;
        this.system = system;
    }

    public boolean hasUnfinishedRules() {
        return !this.rulesUnderConstruction.isEmpty();
    }

    public boolean isProducing(Message message) {
        return this.producedEvents().anyMatch(message::equals);
    }

    @Override
    public String label() {
        return this.label;
    }

    public Stream<Message> producedEvents() {
        return this.rules.stream().flatMap(Rule::producedEvents);
    }

    public Feature rule(Message trigger, Message action1, Message ... moreActions) {
        Rule.RuleWithTriggerBuilder builder = this.rule().feature(this).trigger(trigger);
        builder.action(action1);
        if (moreActions != null) {
            Stream.of(moreActions).forEach(builder::action);
        }
        return builder.build();
    }

    public Rule.RuleWithTriggerBuilder rule(Message trigger, String comment) {
        return this.rule().trigger(trigger, comment);
    }

    public Rule.RuleWithTriggerBuilder rule(Message trigger) {
        return this.rule(trigger, null);
    }

    public Rule.RuleBuilder rule() {
        return Rule.builder(this);
    }

    public List<Rule> rules() {
        return Collections.unmodifiableList(this.rules);
    }

    public System system() {
        return this.system;
    }

    public String toString() {
        return this.label;
    }

    @Override
    @Nullable
    public String wikiFolder(I18n i18n) {
        return this.system.wikiFolder(i18n);
    }
}

