/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.mermaid;

import de.xam.featdoc.LineWriter;
import de.xam.featdoc.mermaid.flowchart.FlowchartDiagram;
import de.xam.featdoc.mermaid.sequence.MermaidDiagram;
import de.xam.featdoc.mermaid.sequence.Note;
import de.xam.featdoc.mermaid.sequence.Participant;
import de.xam.featdoc.mermaid.sequence.SequenceDiagram;
import de.xam.featdoc.mermaid.sequence.SequenceStep;

public class MermaidTool {
    private static final String INDENT = "    ";

    private MermaidTool() {
    }

    public static void generateMermaidSyntax(MermaidDiagram mermaidDiagram, LineWriter lineWriter) {
        if (mermaidDiagram instanceof SequenceDiagram) {
            SequenceDiagram sd = (SequenceDiagram)mermaidDiagram;
            MermaidTool.generateMermaidSyntax(sd, lineWriter);
        } else if (mermaidDiagram instanceof FlowchartDiagram) {
            FlowchartDiagram fd = (FlowchartDiagram)mermaidDiagram;
            MermaidTool.generateMermaidSyntax(fd, lineWriter);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void generateMermaidSyntax(SequenceDiagram sequenceDiagram, LineWriter lineWriter) {
        lineWriter.writeLine("sequenceDiagram", new String[0]);
        lineWriter.writeLine("%%{", new String[0]);
        lineWriter.writeLine("    init: {", new String[0]);
        lineWriter.writeLine("        'fontFamily': 'Tahoma, Arial, Sans-Serif',", new String[0]);
        lineWriter.writeLine("        'sequence': {", new String[0]);
        lineWriter.writeLine("            'mirrorActors':true,", new String[0]);
        lineWriter.writeLine("            'wrap': true", new String[0]);
        lineWriter.writeLine("        }", new String[0]);
        lineWriter.writeLine("    }", new String[0]);
        lineWriter.writeLine("}%%", new String[0]);
        for (Participant participant : sequenceDiagram.participants()) {
            lineWriter.writeLine(INDENT + participant.mermaid(), new String[0]);
        }
        for (Note note : sequenceDiagram.notes()) {
            lineWriter.writeLine(INDENT + note.mermaid(), new String[0]);
        }
        for (SequenceStep sequenceStep : sequenceDiagram.steps()) {
            lineWriter.writeLine(INDENT + sequenceStep.mermaid(), new String[0]);
        }
    }

    public static void generateMermaidSyntax(FlowchartDiagram flowchartDiagram, LineWriter lineWriter) {
        lineWriter.writeLine("graph %s", flowchartDiagram.orientation().name());
        flowchartDiagram.nodeMap().forEach((id, node) -> node.toMermaidSyntax(lineWriter));
        flowchartDiagram.edges().forEach(edge -> lineWriter.writeLine("%s%s --> %s", INDENT, edge.source(), edge.target()));
    }
}

