/*
 * Decompiled with CFR 0.152.
 */
package de.xam.featdoc.system;

import de.xam.featdoc.CausalTree;
import de.xam.featdoc.example.RestaurantSystemsAndScenarios;
import de.xam.featdoc.system.ExampleUniverse;
import de.xam.featdoc.system.GenerateExampleDocumentation;
import de.xam.featdoc.system.Message;
import de.xam.featdoc.system.ResultStep;
import de.xam.featdoc.system.Rule;
import de.xam.featdoc.system.Scenario;
import de.xam.featdoc.system.ScenarioStep;
import de.xam.featdoc.system.System;
import de.xam.featdoc.system.Universe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UniverseTest {
    private static final Logger log = LoggerFactory.getLogger(UniverseTest.class);
    Universe universe = new Universe();
    System systemSource = this.universe.system("sourceSystem", "Source", "sysSource");
    System systemA = this.universe.system("sysa", "A", "sysAAAAAA");
    Message systemA_event = this.systemA.asyncEventOutgoing("a-event");
    Message systemA_call = this.systemA.apiCall("a-call");
    System systemB = this.universe.system("sysb", "B", "sysBBBBBB");
    Message systemB_event = this.systemB.asyncEventOutgoing("b-event");
    Message systemB_call = this.systemB.apiCall("b-call");
    System systemC = this.universe.system("sysc", "C", "sysCCCCCC");
    Message systemC_event = this.systemC.asyncEventOutgoing("c-event");
    Message systemC_call = this.systemC.apiCall("c-call");
    System systemSink = this.universe.system("sink", "Sink", "sys__Sink");
    Message systemSink_call = this.systemSink.apiCall("sink-call");

    UniverseTest() {
    }

    public Scenario createForeignSystemScenario() {
        this.systemB.feature("foreignSystem").rule(this.systemB_call, "c1").action(this.systemB_event, "c2").build();
        this.systemSink.feature("sink").rule(this.systemB_event, "c3").action(this.systemSink_call, "c4").build();
        this.universe.validate();
        Scenario scenario = this.universe.scenario("test").step(this.systemA, this.systemB_call, "c0");
        return scenario;
    }

    @Test
    void causalTree() {
        Scenario scenario = ExampleUniverse.scenario;
        List trees = Universe.toCausalTrees((Scenario)scenario);
        trees.forEach(CausalTree::dump);
    }

    @Test
    void causalTreeCoffee() {
        RestaurantSystemsAndScenarios.define();
        Scenario scenario = (Scenario)RestaurantSystemsAndScenarios.Systems.UNIVERSE.scenarios().get(0);
        List trees = Universe.toCausalTrees((Scenario)scenario);
        trees.forEach(CausalTree::dump);
    }

    @Test
    void generateExample() throws IOException {
        GenerateExampleDocumentation.generateFiles(ExampleUniverse.universe);
    }

    @Test
    void resultingAction() {
        ArrayList<Rule.Action> actionList = new ArrayList<Rule.Action>();
        ExampleUniverse.universe.forEachResultingAction(((ScenarioStep)ExampleUniverse.scenario.steps().get(0)).message(), (rule, action) -> actionList.add((Rule.Action)action), true);
        log.info("Res:\n" + actionList.stream().map(action -> action.message().name()).collect(Collectors.joining("\n,")));
        this.assertActions(actionList, "bCall1", "cCall", "bCall2", "aEventOut", "cCall", "dEventOut", "eEventOut");
    }

    @Test
    void testAAA() {
        this.systemA.feature("rule-under-test").rule(this.systemA_call, this.systemA_event, new Message[0]);
        this.systemSink.feature("sink").rule(this.systemA_event, this.systemSink_call, new Message[0]);
        Scenario scenario = this.universe.scenario("test").step(this.systemSource, this.systemA_call);
    }

    @Test
    void testBAA() {
        this.systemA.feature("rule-under-test").rule(this.systemB_event, this.systemA_event, new Message[0]);
        this.systemSink.feature("sink").rule(this.systemA_event, this.systemSink_call, new Message[0]);
        Scenario scenario = this.universe.scenario("test").step(this.systemSource, this.systemB_event);
    }

    @Test
    void testBridge() {
        this.systemB.feature("bridge").rule(this.systemA_event, "c1").action(this.systemC_call, "c2").build();
        this.universe.validate();
        Scenario scenario = this.universe.scenario("test").step(this.systemA, this.systemA_event, " c3");
        List resultingSteps = this.universe.computeResultingSteps(scenario);
        this.dump("Bridge", resultingSteps);
    }

    @Test
    void testForeignSystem() {
        Scenario scenario = this.createForeignSystemScenario();
        List resultingSteps = this.universe.computeResultingSteps(scenario);
        this.dump("ForeignSystem", resultingSteps);
    }

    private void assertActions(List<Rule.Action> actual, String ... expected) {
        List actualList = actual.stream().map(action -> action.message().name()).collect(Collectors.toList());
        List<String> expectedList = Arrays.asList(expected);
        Assertions.assertIterableEquals(expectedList, actualList, (String)(" Actual: " + actualList));
    }

    private void dump(String s, List<ResultStep> resultingSteps) {
        StringBuilder b = new StringBuilder();
        b.append("== " + s + "\n");
        for (ResultStep rs : resultingSteps) {
            b.append(s + "   " + rs + "\n");
        }
        log.info("\n" + b.toString());
    }

    static {
        ExampleUniverse.define();
    }
}

