/**
 * Copyright (c) 2025 Wunderkopf Technologies GmbH
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

package de.wunderkopfservices.creditscore.client.internal;

import java.util.List;
import java.util.Map;

public class WkApiClientException extends Exception {

	private static final long serialVersionUID = 1L;

	private String body;
	private int statusCode;
	
	public WkApiClientException(String message, String body, int status) {
		super(message);
		this.body = body;
		this.statusCode = status;
	}
	
	public WkApiClientException(String message, Throwable e) {
		super(message);
		this.initCause(e);
	}
	
	public String getBody() {
		return body;
	}
	public int getStatusCode() {
		return statusCode;
	}
	
	public static WkApiClientException ofApiError(String call, String body, int status) {
		
		Map<String, Object> errorContainer = null;
		if (status <= 502) {
			try {
				errorContainer = JSON.parseMap(body);
			} catch (Exception e) {}
		}
		
		Map<String, Object> error = null;
		if (errorContainer != null && errorContainer.containsKey("error")) {
			List<Map<String, Object>> errors = (List<Map<String, Object>>) errorContainer.get("error");
			if (errors.size() > 0) {
				error = errors.get(0);
			}

		}
		
		String errorMessage = call + " failed with [status=" + status + "]";
		if (error != null) {
			String reason = error.containsKey("message_localized")
					? (String) error.get("message_localized")
					: (String) error.get("message");
			errorMessage += " with reason: " + reason;
		}
		
		return new WkApiClientException(errorMessage, body, status);
	}
	
}
